/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.attributes.Box2D;
import fang2.attributes.Location2D;
import fang2.attributes.Palette;
import fang2.attributes.Vector2D;
import fang2.core.AnimationCanvas;
import fang2.core.Game;
import fang2.core.Transformer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sprite {
    public static final int DEBUG_BOUNDING_BOX = 1;
    public static final int DEBUG_INTERSECTS = 2;
    private static BasicStroke debugStroke = null;
    private static Color FANG_BLUE = Palette.getColor("FANG Blue");
    private static Color FANG_WHITE = Palette.getColor("white");
    private static final double TwoPI = Math.PI * 2;
    protected static Color debugBoundingBoxColor = new Color(128, 50, 50);
    public AffineTransform transform;
    private int debug = 0;
    private boolean destroy = false;
    private boolean enabled = true;
    private Point2D.Double oldLocation;
    private double oldScale;
    private int pathLength = 0;
    private BasicStroke stroke = new BasicStroke(0.04f, 0, 2);
    private boolean useBoundingBox = false;
    private boolean visible = true;
    protected Color color;
    protected GraphicsConfiguration config;
    protected VolatileImage image;
    protected boolean optimizeForBitmap = false;
    protected Shape outline;
    protected Color outlineColor;
    protected double outlineWidth = -1.0;
    protected GeneralPath shape;
    protected List<Transformer> transformers;

    public static Color getDebugBoundingBoxColor() {
        return debugBoundingBoxColor;
    }

    public static Color getDefaultColor() {
        return FANG_BLUE;
    }

    public static Color getDefaultOutlineColor() {
        return FANG_WHITE;
    }

    public static double getNormalVector(Shape shape, Shape shape2) {
        Area area = new Area(shape2);
        Area area2 = new Area(shape);
        Area area3 = new Area(area2);
        area3.intersect(new Area(area));
        if (area3.isEmpty()) {
            return Double.NaN;
        }
        Rectangle2D rectangle2D = shape2.getBounds2D();
        Rectangle2D rectangle2D2 = area3.getBounds2D();
        Point2D.Double double_ = new Point2D.Double(rectangle2D.getCenterX() - rectangle2D2.getCenterX(), rectangle2D.getCenterY() - rectangle2D2.getCenterY());
        return Math.atan2(double_.y, double_.x);
    }

    public static double getNormalVector(Sprite sprite, Sprite sprite2) {
        return Sprite.getNormalVector(sprite.getShape(), sprite2.getShape());
    }

    public static boolean intersects(Shape shape, Shape shape2) {
        Area area = new Area(new Area(shape));
        area.intersect(new Area(shape2));
        return !area.isEmpty();
    }

    public static void setDebugBoundingBoxColor(Color color) {
        debugBoundingBoxColor = color;
    }

    public static void setDefaultColor(Color color) {
        FANG_BLUE = color;
    }

    private static BasicStroke getDebugStroke() {
        if (debugStroke == null) {
            debugStroke = new BasicStroke(0.01f);
        }
        return debugStroke;
    }

    public Sprite() {
        this.transform = new AffineTransform();
        this.color = FANG_BLUE;
        this.outlineColor = FANG_WHITE;
        this.shape = new GeneralPath();
        this.transformers = new ArrayList<Transformer>();
    }

    public Sprite(Shape shape) {
        this();
        this.setShape(shape);
        double d = Math.max(shape.getBounds2D().getHeight(), shape.getBounds2D().getWidth());
        this.setScale(d);
    }

    public void addTransformer(Transformer transformer) {
        if (!this.transformers.contains(transformer)) {
            this.transformers.add(transformer);
            this.dirtyTransformers();
        }
    }

    public void applyTransformerNG() {
        if (this.isEnabled()) {
            for (Transformer transformer : this.transformers) {
                transformer.updateSprite(this);
            }
        }
    }

    public void update() {
    }

    public void copyTransformersFrom(Sprite sprite) {
        for (Transformer transformer : sprite.getTransformers()) {
            this.addTransformer(transformer);
        }
    }

    public void disableTransformer() {
        this.enabled = false;
    }

    public void enableTransformer() {
        this.enabled = true;
    }

    public void forward(double d) {
        this.translate(this.getFacingVector().multiply(d));
    }

    public int getBlurLength() {
        return this.pathLength;
    }

    public Box2D getBounds2D() {
        Rectangle2D rectangle2D = this.getShape().getBounds2D();
        return new Box2D(rectangle2D);
    }

    public Color getColor() {
        return this.color;
    }

    public double getDashLength() {
        float[] fArray = this.stroke.getDashArray();
        if (fArray.length == 0) {
            return 0.0;
        }
        return (double)fArray[0] * this.getSize();
    }

    public float[] getDashPattern() {
        float[] fArray = this.stroke.getDashArray();
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = (float)((double)fArray[n2] * this.getSize());
        }
        return fArray;
    }

    public int getDebug() {
        return this.debug;
    }

    public Vector2D getFacingVector() {
        return new Vector2D(-this.getRotationDegrees(), 1.0);
    }

    public double getHeight() {
        return this.getBounds2D().getHeight();
    }

    public Location2D getLocation() {
        return new Location2D(this.internalGetLocation());
    }

    public double getMaxX() {
        return this.getBounds2D().getMaxX();
    }

    public double getMaxY() {
        return this.getBounds2D().getMaxY();
    }

    public double getMinX() {
        return this.getBounds2D().getMinX();
    }

    public double getMinY() {
        return this.getBounds2D().getMinY();
    }

    public boolean getOptimizedForBitmap() {
        return this.optimizeForBitmap;
    }

    public double getOrientation() {
        return this.getRotation();
    }

    public double getOrientationDegrees() {
        return this.getRotationDegrees();
    }

    public double getOrientationRadians() {
        return this.getRotationRadians();
    }

    public double getOrientationRevolutions() {
        return this.getRotationRevolutions();
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public double getOutlineThickness() {
        return this.outlineWidth / 2.0 * this.getScale();
    }

    public double getRotation() {
        AffineTransform affineTransform = new AffineTransform(this.transform);
        affineTransform.translate(-affineTransform.getTranslateX(), -affineTransform.getTranslateY());
        double d = this.internalGetScale();
        affineTransform.scale(1.0 / d, 1.0 / d);
        double d2 = Math.acos(affineTransform.getScaleX());
        if (Math.asin(-affineTransform.getShearX()) < 0.0) {
            d2 *= -1.0;
        }
        return d2;
    }

    public double getRotationDegrees() {
        return Math.toDegrees(this.getRotation());
    }

    public double getRotationRadians() {
        return this.getRotation();
    }

    public double getRotationRevolutions() {
        return this.getRotation() / (Math.PI * 2);
    }

    public double getScale() {
        return this.internalGetScale();
    }

    public Shape getShape() {
        return this.shape.createTransformedShape(this.transform);
    }

    public double getSize() {
        return this.getScale();
    }

    public boolean getUseBoundingBox() {
        return this.useBoundingBox;
    }

    public double getWidth() {
        return this.getBounds2D().getWidth();
    }

    public double getX() {
        return this.internalGetLocation().x;
    }

    public double getY() {
        return this.internalGetLocation().y;
    }

    public void hide() {
        this.setVisible(false);
    }

    public void hideOutline() {
        this.outline = null;
    }

    public boolean intersects(double d, double d2) {
        Area area = new Area(this.getShape());
        return area.contains(d, d2);
    }

    public boolean intersects(Location2D location2D) {
        return this.intersects(location2D.x, location2D.y);
    }

    public boolean intersects(Point2D.Double double_) {
        return this.intersects(double_.x, double_.y);
    }

    public boolean intersects(Sprite sprite) {
        Rectangle2D rectangle2D = sprite.getBounds2D().Rectangle2D();
        Rectangle2D rectangle2D2 = this.getBounds2D().Rectangle2D();
        if ((this.debug & 2) != 0) {
            System.out.println("intersects: ");
            System.out.println("  this = " + this + " bounds = [" + rectangle2D2.getX() + ", " + rectangle2D2.getY() + ", " + rectangle2D2.getWidth() + ", " + rectangle2D2.getHeight() + "]");
            System.out.println("  sprite = " + sprite + " spriteBounds = " + rectangle2D);
        }
        if (!rectangle2D2.intersects(rectangle2D)) {
            return false;
        }
        Area area = this.getUnrotatedBoundaryArea();
        Area area2 = sprite.getUnrotatedBoundaryArea();
        area = this.rotate(area, this.getRotation());
        area2 = this.rotate(area2, sprite.getRotation());
        if (!area.intersects(rectangle2D) || !area2.intersects(rectangle2D2)) {
            return false;
        }
        Area area3 = new Area(area);
        area3.intersect(area2);
        if (area3.isEmpty()) {
            return false;
        }
        if (sprite.getUseBoundingBox() && this.getUseBoundingBox()) {
            return true;
        }
        if (this.getUseBoundingBox()) {
            Area area4 = new Area(sprite.getShape());
            area4.intersect(area);
            return sprite.getShape().intersects(rectangle2D2) && !area4.isEmpty();
        }
        if (sprite.getUseBoundingBox()) {
            Area area5 = new Area(this.getShape());
            area5.intersect(area2);
            return this.getShape().intersects(rectangle2D) && !area5.isEmpty();
        }
        Area area6 = new Area(this.getShape());
        Area area7 = new Area(sprite.getShape());
        area6.intersect(area7);
        return !area6.isEmpty();
    }

    private Area rotate(Area area, double d) {
        Rectangle2D rectangle2D = area.getBounds2D();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle2D.getCenterX(), rectangle2D.getCenterY());
        affineTransform.rotate(d);
        affineTransform.translate(-rectangle2D.getCenterX(), -rectangle2D.getCenterY());
        area.transform(affineTransform);
        return area;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void paint(Graphics2D graphics2D) {
        if (this.optimizeForBitmap) {
            if (this.image == null) {
                this.config = graphics2D.getDeviceConfiguration();
                this.image = this.createImage();
                this.restoreImage();
            }
            if (this.image.contentsLost()) {
                this.restoreImage();
            }
            Point2D.Double double_ = this.internalGetLocation();
            graphics2D.drawImage(this.image, (int)double_.x - this.image.getWidth() / 2, (int)double_.y - this.image.getHeight() / 2, null);
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            Color color = graphics2D.getColor();
            graphics2D.transform(this.transform);
            graphics2D.setColor(this.color);
            this.paintShape(graphics2D);
            if (this.outline != null) {
                graphics2D.setColor(this.outlineColor);
                graphics2D.fill(this.outline);
            }
            graphics2D.setColor(color);
            graphics2D.setTransform(affineTransform);
        }
        if ((this.debug & 1) != 0) {
            this.drawDebugShapes(graphics2D);
        }
    }

    public void paintInternal(Graphics2D graphics2D) {
        if (this.oldLocation == null) {
            this.oldLocation = this.getLocation();
            this.oldScale = this.getScale();
        }
        double d = this.getScale();
        Location2D location2D = this.getLocation();
        if (this.visible && this.enabled) {
            if (!(this.pathLength <= 0 || this.oldLocation.equals(location2D) && this.oldScale == d)) {
                Color color = this.getColor();
                int n = color.getAlpha();
                for (int i = 0; i < this.pathLength; ++i) {
                    double d2 = ((double)i + 1.0) / ((double)this.pathLength + 2.0);
                    this.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)((double)n * d2)));
                    this.setScale(this.oldScale + d2 * (d - this.oldScale));
                    this.setLocation(this.oldLocation.x + d2 * (location2D.x - this.oldLocation.x), this.oldLocation.y + d2 * (location2D.y - this.oldLocation.y));
                    this.paint(graphics2D);
                }
                this.setColor(color);
                this.setScale(d);
                this.setLocation((Point2D.Double)location2D);
                this.paint(graphics2D);
            } else {
                this.paint(graphics2D);
            }
        }
        this.oldScale = d;
        this.oldLocation = location2D;
    }

    public void removeFromCanvas() {
        this.destroy = true;
        this.enabled = false;
    }

    public void removeTransformer(Transformer transformer) {
        this.transformers.remove(transformer);
        this.dirtyTransformers();
    }

    public void rotate(double d) {
        this.setRotation(this.getRotation() + d);
    }

    public void rotateDegrees(double d) {
        this.rotate(Math.toRadians(d));
    }

    public void rotateRadians(double d) {
        this.rotate(d);
    }

    public void rotateRevolutions(double d) {
        this.rotate(d * Math.PI * 2.0);
    }

    public void scale(double d) {
        this.setScale(d * this.internalGetScale());
    }

    public void setBlurLength(int n) {
        this.pathLength = n;
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.optimizeForBitmap) {
            this.restoreImage();
        }
    }

    public void setDashLength(double d) {
        float[] fArray = new float[]{(float)(d / this.getSize()), (float)(d / this.getSize())};
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), fArray, this.stroke.getDashPhase());
        if (this.outline != null) {
            this.outline = null;
            this.showOutline();
        }
    }

    public void setDashPattern(float ... fArray) {
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = (float)((double)fArray[n2] / this.getSize());
        }
        this.stroke = new BasicStroke(this.stroke.getLineWidth(), this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), fArray, this.stroke.getDashPhase());
        if (this.outline != null) {
            this.outline = null;
            this.showOutline();
        }
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void setLocation(double d, double d2) {
        this.transform.setTransform(this.transform.getScaleX(), this.transform.getShearY(), this.transform.getShearX(), this.transform.getScaleY(), d, d2);
    }

    public void setLocation(Location2D location2D) {
        this.setLocation(location2D.x, location2D.y);
    }

    public void setLocation(Point2D.Double double_) {
        this.setLocation(double_.x, double_.y);
    }

    public void setOptimizedForBitmap(boolean bl) {
    }

    public void setOrientation(double d) {
        this.setRotation(d);
    }

    public void setOrientationDegrees(double d) {
        this.setRotation(Math.toRadians(d));
    }

    public void setOrientationRadians(double d) {
        this.setRotation(d);
    }

    public void setOrientationRevolutions(double d) {
        this.setRotation(d * Math.PI * 2.0);
    }

    public void setOutlineColor(Color color) {
        this.outlineColor = color;
    }

    public void setOutlineThickness(double d) {
        this.outlineWidth = d >= 0.0 ? d * 2.0 / this.getScale() : 0.0;
        if (this.outline != null) {
            this.outline = null;
            this.showOutline();
        }
    }

    public void setOutlineVisible(boolean bl) {
        if (bl) {
            this.showOutline();
        } else {
            this.hideOutline();
        }
    }

    public void setRotation(double d) {
        this.transform.rotate(d - this.getRotation());
        if (this.optimizeForBitmap) {
            this.restoreImage();
        }
    }

    public void setRotationDegrees(double d) {
        this.setRotation(Math.toRadians(d));
    }

    public void setRotationRadians(double d) {
        this.setRotation(d);
    }

    public void setRotationRevolutions(double d) {
        this.setRotation(d * Math.PI * 2.0);
    }

    public void setScale(double d) {
        double d2;
        if (d == 0.0) {
            d = 1.0E-5;
        }
        if ((d /= Math.sqrt(d2 = this.transform.getScaleX() * this.transform.getScaleY() - this.transform.getShearX() * this.transform.getShearY())) == 1.0) {
            return;
        }
        this.transform.setTransform(d * this.transform.getScaleX(), d * this.transform.getShearY(), d * this.transform.getShearX(), d * this.transform.getScaleY(), this.transform.getTranslateX(), this.transform.getTranslateY());
        if (this.optimizeForBitmap) {
            this.restoreImage();
        }
    }

    public void setSize(double d) {
        this.setScale(d);
    }

    public void setUseBoundingBox(boolean bl) {
        this.useBoundingBox = bl;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setX(double d) {
        this.setLocation(d, this.internalGetLocation().y);
    }

    public void setY(double d) {
        this.setLocation(this.internalGetLocation().x, d);
    }

    public void show() {
        this.setVisible(true);
    }

    public void showOutline() {
        if (this.outlineWidth < 0.0) {
            this.outlineWidth = 0.02 / this.getScale();
        }
        if (this.outline == null) {
            this.stroke = new BasicStroke((float)this.outlineWidth, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), 0.0f);
            Area area = new Area(this.shape.getBounds2D());
            area.intersect(new Area(this.shape));
            Area area2 = new Area(this.stroke.createStrokedShape(area));
            area2.intersect(new Area(this.shape));
            this.outline = area2;
        }
    }

    public String toString() {
        return this.getClass().getName() + "[x = " + this.getX() + ", y = " + this.getY() + "], " + "[w = " + this.getWidth() + ", h = " + this.getHeight() + "] color = " + Palette.getColorName(this.getColor());
    }

    public void translate(double d, double d2) {
        this.setLocation(d + this.transform.getTranslateX(), d2 + this.transform.getTranslateY());
    }

    public void translate(Location2D location2D) {
        this.translate(location2D.x, location2D.y);
    }

    public void translate(Point2D.Double double_) {
        this.translate(double_.x, double_.y);
    }

    public void translate(Vector2D vector2D) {
        this.translate(vector2D.getX(), vector2D.getY());
    }

    public void translateX(double d) {
        this.translate(d, 0.0);
    }

    public void translateY(double d) {
        this.translate(0.0, d);
    }

    private VolatileImage createImage() {
        Rectangle2D rectangle2D = this.getShape().getBounds2D();
        return this.config.createCompatibleVolatileImage((int)rectangle2D.getWidth() + 1, (int)rectangle2D.getHeight() + 1, 3);
    }

    private void dirtyTransformers() {
        AnimationCanvas animationCanvas = Game.getCurrentGame().getCanvas();
        if (animationCanvas != null) {
            animationCanvas.allTransformersDirty = true;
        }
    }

    private Area getUnrotatedBoundaryArea() {
        double d = this.getRotation();
        this.setRotation(0.0);
        Rectangle2D rectangle2D = this.getBounds2D().Rectangle2D();
        this.setRotation(d);
        GeneralPath generalPath = new GeneralPath(rectangle2D);
        return new Area(generalPath);
    }

    private Point2D.Double internalGetLocation() {
        return new Point2D.Double(this.transform.getTranslateX(), this.transform.getTranslateY());
    }

    private double internalGetScale() {
        double d = this.transform.getScaleX() * this.transform.getScaleY() - this.transform.getShearX() * this.transform.getShearY();
        return Math.sqrt(d);
    }

    private void restoreImage() {
        if (this.image == null) {
            return;
        }
        int n = this.image.validate(this.config);
        Rectangle2D rectangle2D = this.getShape().getBounds2D();
        if (n == 2 || rectangle2D.getWidth() > (double)this.image.getWidth() || rectangle2D.getHeight() > (double)this.image.getHeight()) {
            this.image = this.createImage();
        }
        Graphics2D graphics2D = this.image.createGraphics();
        graphics2D.setBackground(new Color(0, 0, 0, 0));
        graphics2D.clearRect(0, 0, this.image.getWidth(), this.image.getHeight());
        graphics2D.translate(-rectangle2D.getMinX() + ((double)this.image.getWidth() - rectangle2D.getWidth()) / 2.0, -rectangle2D.getMinY() + ((double)this.image.getHeight() - rectangle2D.getHeight()) / 2.0);
        graphics2D.setColor(this.color);
        RenderingHints renderingHints = new RenderingHints(null);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.addRenderingHints(renderingHints);
        graphics2D.fill(this.getShape());
    }

    protected void drawDebugShapes(Graphics2D graphics2D) {
        this.setDebugBrush(debugBoundingBoxColor, graphics2D);
        Box2D box2D = this.getBounds2D();
        graphics2D.draw(box2D.Rectangle2D());
    }

    protected List<Transformer> getTransformers() {
        return this.transformers;
    }

    protected boolean isDestroyed() {
        return this.destroy;
    }

    protected void normalize() {
        Rectangle2D rectangle2D = this.shape.getBounds2D();
        double d = Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
        this.shape.transform(AffineTransform.getScaleInstance(1.0 / d, 1.0 / d));
        rectangle2D = this.shape.getBounds2D();
        this.shape.transform(AffineTransform.getTranslateInstance(-rectangle2D.getWidth() / 2.0 - rectangle2D.getX(), -rectangle2D.getHeight() / 2.0 - rectangle2D.getY()));
    }

    protected void paintShape(Graphics2D graphics2D) {
        graphics2D.fill(this.shape);
    }

    protected void setAbsoluteShape(Shape shape) {
        Rectangle2D rectangle2D = shape.getBounds2D();
        double d = Math.max(rectangle2D.getWidth(), rectangle2D.getHeight());
        double d2 = rectangle2D.getCenterX();
        double d3 = rectangle2D.getCenterY();
        this.setShape(shape);
        this.setLocation(d2, d3);
        this.setSize(d);
    }

    protected void setDebugBrush(Color color, Graphics2D graphics2D) {
        graphics2D.setStroke(Sprite.getDebugStroke());
        graphics2D.setColor(color);
    }

    protected void setShape(Shape shape) {
        this.shape.reset();
        this.shape.append(shape, true);
        this.normalize();
    }

    public void reportTransformers(Set<Transformer> set) {
        if (this.isEnabled()) {
            for (Transformer transformer : this.transformers) {
                set.add(transformer);
            }
        }
    }
}

