/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.core.AnimationCanvas;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Observer;

public class Keyboard
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private char key;
    private Observer observer;
    protected Listener listener = new Listener();

    public Keyboard() {
        this.clear();
    }

    public String toString() {
        return this.key + " is last pressed";
    }

    public void clear() {
        this.key = (char)65535;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeChar(this.key);
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        char c = objectInput.readChar();
        if (c != '\uffff') {
            this.key = c;
        }
    }

    public char getLastKey() {
        return this.key;
    }

    public char getKeyPressed() {
        return this.getLastKey();
    }

    public char getLowerCaseKeyPressed() {
        return Character.toLowerCase(this.getLastKey());
    }

    public char getUpperCaseKeyPressed() {
        return Character.toUpperCase(this.getLastKey());
    }

    public boolean upPressed() {
        return '&' == this.key || '\u00e0' == this.key;
    }

    public boolean downPressed() {
        return '(' == this.key || this.key == '\u00e1';
    }

    public boolean leftPressed() {
        return '%' == this.key || this.key == '\u00e2';
    }

    public boolean rightPressed() {
        return '\'' == this.key || this.key == '\u00e3';
    }

    public boolean keyPressed() {
        return this.key != '\uffff';
    }

    public void setLastKey(char c) {
        this.key = c;
        if (this.observer != null) {
            this.observer.update(null, null);
        }
    }

    public void setCanvas(AnimationCanvas animationCanvas) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.listener);
    }

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    protected class Listener
    implements KeyEventDispatcher {
        protected Listener() {
        }

        public boolean dispatchKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.getID() == 401) {
                char c = keyEvent.getKeyChar() == '\uffff' ? (char)keyEvent.getKeyCode() : keyEvent.getKeyChar();
                Keyboard.this.setLastKey(c);
            }
            return false;
        }
    }
}

