/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.attributes.Palette;
import fang2.core.Alarm;
import fang2.core.AlarmAdapter;
import fang2.core.AnimationCanvas;
import fang2.core.Game;
import fang2.core.GameLevel;
import fang2.core.GameLoop;
import fang2.core.Player;
import fang2.core.Sound;
import fang2.core.Sprite;
import fang2.media.RawMediaCache;
import fang2.sprites.LineSprite;
import fang2.sprites.StringSprite;
import fang2.ui.ErrorConsole;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class GameRedirection
extends GameLoop {
    protected Game firstGame;
    protected Game currentGame;
    protected ArrayList<Game> upcomingGames;
    protected ArrayList<Game> addedGames;
    protected boolean finishingGame;
    protected boolean restarting;
    protected boolean activated = false;
    private final HashSet<Alarm> persistentAlarms = new HashSet();
    private final HashSet<Sprite> persistentSprites = new HashSet();
    private final HashSet<Sound> persistentSounds = new HashSet();

    public GameRedirection(Dimension dimension, Color color) {
        super(dimension, color);
        this.initGameRedirection();
    }

    private void initGameRedirection() {
        this.firstGame = (Game)this;
        if (this.currentGame == null) {
            this.currentGame = (Game)this;
        }
        this.upcomingGames = new ArrayList();
        this.addedGames = new ArrayList();
        this.finishingGame = false;
        this.restarting = false;
        this.resetTime();
    }

    protected void copyFirstFields() {
        this.random = this.firstGame.random;
        this.player = this.firstGame.player;
        this.timeInterval = this.firstGame.timeInterval;
        this.players = this.firstGame.players;
        this.player = this.firstGame.player;
        this.playersSelectable = this.firstGame.playersSelectable;
        this.serverSelectable = this.firstGame.serverSelectable;
        this.sessionSelectable = this.firstGame.sessionSelectable;
        this.fullScreen = this.firstGame.fullScreen;
        this.client = this.firstGame.client;
        this.client.setGameLoop(this.currentGame);
        this.canvas = this.firstGame.canvas;
        this.help = this.firstGame.help;
        this.setCreateOwnFrame(this.firstGame.isCreatingOwnFrame());
        this.setNumberOfPlayers(this.firstGame.getNumberOfPlayers());
        this.setServerName(this.firstGame.getServerName());
    }

    protected Game getSharedCurrentGame() {
        return this.currentGame;
    }

    public static Game getCurrentGame() {
        return sharedCurrentGame;
    }

    public void addGame(Game game) {
        this.addedGames.add(game);
    }

    public void finishGame() {
        this.currentGame.finishingGame = true;
        this.currentGame.activated = false;
    }

    protected void reallyFinishGame() {
        this.addedGames.addAll(this.upcomingGames);
        this.upcomingGames.clear();
        this.upcomingGames.addAll(this.addedGames);
        this.addedGames.clear();
        this.currentGame.finishingGame = false;
        this.cleanUp();
        this.removeLevelObjects();
        if (this.upcomingGames.size() != 0) {
            Game game = this.upcomingGames.get(0);
            this.upcomingGames.remove(0);
            game.firstGame = this.firstGame;
            game.copyFirstFields();
            game.upcomingGames.clear();
            game.upcomingGames.addAll(this.currentGame.upcomingGames);
            this.currentGame = game;
            this.firstGame.currentGame = game;
            this.firstGame.initializeCurrentGame();
            super.setupWhenMediaLoaded();
        }
    }

    @Deprecated
    public final void addLevel(GameLevel gameLevel) {
    }

    @Deprecated
    public final void finishLevel() {
    }

    @Deprecated
    public final GameLevel getNextLevel() {
        return null;
    }

    @Deprecated
    public final void advanceLevel() {
    }

    @Deprecated
    public final int getLevelNumber() {
        return -1;
    }

    @Deprecated
    public final void setNextLevel(GameLevel gameLevel) {
    }

    @Deprecated
    public final void advanceFrame(double d) {
        this.currentGame.advance(d);
        if (this.currentGame.restarting) {
            this.currentGame.reallyStartOver();
        }
        if (this.currentGame.finishingGame) {
            this.currentGame.reallyFinishGame();
        }
    }

    public void advance(double d) {
        this.advance();
    }

    public abstract void advance();

    protected void removeLevelObjects() {
        Sprite[] spriteArray = this.canvas.getAllSprites();
        Object[] objectArray = spriteArray;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Sprite sprite = objectArray[i];
            if (this.persistentSprites.contains(sprite)) continue;
            this.canvas.removeSprite(sprite);
        }
        for (Object object : objectArray = this.getAlarms()) {
            if (this.persistentAlarms.contains(object)) continue;
            this.cancelAlarm((Alarm)object);
        }
    }

    public void startOver() {
        this.currentGame.restarting = true;
    }

    protected void reallyStartOver() {
        this.currentGame.restarting = false;
        this.restoreCursor();
        this.resetTime();
        this.canvas.removeAllSprites();
        this.cancelAllAlarms();
        this.client.clearInput();
        this.cleanUp();
        this.upcomingGames.clear();
        this.addedGames.clear();
        this.currentGame = this.firstGame;
        this.firstGame.startGame();
    }

    public void cleanUp() {
    }

    public void persist(Alarm alarm) {
        this.persistentAlarms.add(alarm);
    }

    public void persist(Sprite sprite) {
        this.persistentSprites.add(sprite);
    }

    public void persist(Sound sound) {
        this.persistentSounds.add(sound);
    }

    public void initializePersistantState(Alarm[] alarmArray, Sprite[] spriteArray, Sound[] soundArray) {
        for (Alarm object : alarmArray) {
            this.persistentAlarms.add(object);
        }
        for (Sprite sprite : spriteArray) {
            this.persistentSprites.add(sprite);
        }
        for (Sound sound : soundArray) {
            this.persistentSounds.add(sound);
        }
    }

    public abstract void setup();

    private void setupWhenMediaLoaded() {
        if (RawMediaCache.getQueueLength() == 0 || this.getNumberOfPlayers() > 1) {
            this.setup();
            this.activated = true;
        } else {
            final int n = RawMediaCache.getQueueLength();
            final StringSprite stringSprite = new StringSprite("Loading 0/" + n + "\n" + "Please wait...");
            stringSprite.setLineHeight(0.1);
            stringSprite.setLocation(0.25, 0.5);
            stringSprite.leftJustify();
            stringSprite.topJustify();
            this.currentGame.addSprite(stringSprite);
            final LineSprite lineSprite = new LineSprite(0.25, 0.4, 0.25, 0.4);
            lineSprite.setColor(Palette.getColor("white"));
            final LineSprite lineSprite2 = new LineSprite(0.25, 0.4, 0.75, 0.4);
            lineSprite2.setColor(Palette.getColor("white", 120));
            this.currentGame.addSprite(lineSprite2);
            this.currentGame.addSprite(lineSprite);
            this.currentGame.pause();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Runnable runnable = new Runnable(){

                        public void run() {
                            int n = n - RawMediaCache.getQueueLength();
                            stringSprite.setText("Loading: " + n + "/" + n + "\n" + "Please wait...");
                            lineSprite.setEnd(0.25 + (double)n * 0.5 / (double)n, 0.4);
                            GameRedirection.this.currentGame.getCanvas().paintImmediately();
                        }
                    };
                    while (RawMediaCache.getQueueLength() > 0) {
                        try {
                            EventQueue.invokeAndWait(runnable);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            invocationTargetException.printStackTrace();
                        }
                        1 var2_2 = this;
                        synchronized (var2_2) {
                            try {
                                this.wait(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                        }
                    }
                    GameRedirection.this.currentGame.removeSprite(stringSprite);
                    GameRedirection.this.currentGame.removeSprite(lineSprite);
                    GameRedirection.this.currentGame.removeSprite(lineSprite2);
                    GameRedirection.this.setup();
                    GameRedirection.this.activated = true;
                    GameRedirection.this.resume();
                }
            }).start();
        }
    }

    public final void startGame() {
        this.currentGame = (Game)this;
        ErrorConsole.clear();
        this.setupWhenMediaLoaded();
    }

    protected void copyFrom(Game game) {
    }

    public final void toggleSound() {
        if (this.firstGame == this) {
            super.toggleSound();
        } else {
            this.firstGame.toggleSound();
        }
    }

    @Deprecated
    protected final void toggleAudible() {
        this.toggleSound();
    }

    public boolean isMuted() {
        if (this.firstGame == this) {
            return super.isMuted();
        }
        return this.firstGame.isMuted();
    }

    public void muteSound() {
        if (this.firstGame == this) {
            super.muteSound();
        } else {
            this.firstGame.muteSound();
        }
    }

    public void playSound() {
        if (this.firstGame == this) {
            super.playSound();
        } else {
            this.firstGame.playSound();
        }
    }

    public void pause() {
        if (this.firstGame == this) {
            super.pause();
        } else {
            this.firstGame.pause();
        }
    }

    public void resume() {
        if (this.firstGame == this) {
            super.resume();
        } else {
            this.firstGame.resume();
        }
    }

    public void startGameImmediately() {
        if (this.firstGame == this) {
            super.startGameImmediately();
        } else {
            this.firstGame.startGameImmediately();
        }
    }

    public void playSoundImmediately() {
        if (this.firstGame == this) {
            super.playSoundImmediately();
        } else {
            this.firstGame.playSoundImmediately();
        }
    }

    public void begin() {
        if (this.firstGame == this) {
            super.begin();
        } else {
            this.firstGame.begin();
        }
    }

    public final void setServerName(String string) {
        if (this.firstGame == this) {
            super.setServerName(string);
        } else {
            this.firstGame.setServerName(string);
        }
    }

    public final void setSessionName(String string) {
        if (this.firstGame == this) {
            super.setSessionName(string);
        } else {
            this.firstGame.setSessionName(string);
        }
    }

    public String getSessionName() {
        if (this.firstGame == this) {
            return super.getSessionName();
        }
        return this.firstGame.getSessionName();
    }

    public String getServerName() {
        if (this.firstGame == this) {
            return super.getServerName();
        }
        return this.firstGame.getServerName();
    }

    public final void setGameName(String string) {
        if (this.firstGame == this) {
            super.setGameName(string);
        } else {
            this.firstGame.setGameName(string);
        }
    }

    public String getGameName() {
        if (this.firstGame == this) {
            return super.getGameName();
        }
        return this.firstGame.getGameName();
    }

    public final void setNumberOfPlayers(int n) {
        if (this.firstGame == this) {
            super.setNumberOfPlayers(n);
        } else {
            this.firstGame.setNumberOfPlayers(n);
        }
    }

    public int getNumberOfPlayers() {
        if (this.firstGame == this) {
            return super.getNumberOfPlayers();
        }
        return this.firstGame.getNumberOfPlayers();
    }

    public void sendMessage(Object object) {
        if (this.firstGame == this) {
            super.sendMessage(object);
        } else {
            this.firstGame.sendMessage(object);
        }
    }

    public final void connect(String string, String string2, String string3, int n) {
        if (this.firstGame == this) {
            super.connect(string, string2, string3, n);
        } else {
            this.firstGame.connect(string, string2, string3, n);
        }
    }

    public final void stop() {
        if (this.firstGame == this) {
            super.stop();
        } else {
            this.firstGame.stop();
        }
    }

    public final void disconnect() {
        if (this.firstGame == this) {
            super.disconnect();
        } else {
            this.firstGame.disconnect();
        }
    }

    public boolean isPaused() {
        if (this.firstGame == this) {
            return super.isPaused();
        }
        return this.firstGame.isPaused();
    }

    public final void togglePause() {
        if (this.firstGame == this) {
            super.togglePause();
        } else {
            this.firstGame.togglePause();
        }
    }

    protected final void pauseToggle() {
        if (this.firstGame == this) {
            super.pauseToggle();
        } else {
            this.firstGame.pauseToggle();
        }
    }

    public final void serverSaysPauseToggle() {
        if (this.firstGame == this) {
            super.serverSaysPauseToggle();
        } else {
            this.firstGame.serverSaysPauseToggle();
        }
    }

    public int getID() {
        if (this.firstGame == this) {
            return super.getID();
        }
        return this.firstGame.getID();
    }

    public Player getPlayer(int n) {
        if (this.firstGame == this) {
            return super.getPlayer(n);
        }
        return this.firstGame.getPlayer(n);
    }

    public Player getPlayer(String string) {
        if (this.firstGame == this) {
            return super.getPlayer(string);
        }
        return this.firstGame.getPlayer(string);
    }

    public final boolean gameIsOver() {
        if (this.firstGame == this) {
            return super.gameIsOver();
        }
        return this.firstGame.gameIsOver();
    }

    public boolean isGameOver() {
        if (this.firstGame == this) {
            return super.gameIsOver();
        }
        return this.firstGame.gameIsOver();
    }

    public void setGameOver(boolean bl) {
        if (this.firstGame == this) {
            super.setGameOver(bl);
        } else {
            this.firstGame.setGameOver(bl);
        }
    }

    public Player getPlayer() {
        if (this.firstGame == this) {
            return super.getPlayer();
        }
        return this.firstGame.getPlayer();
    }

    public void setCanvas(AnimationCanvas animationCanvas) {
        if (this.firstGame == this) {
            super.setCanvas(animationCanvas);
        } else {
            this.firstGame.setCanvas(animationCanvas);
        }
    }

    public AnimationCanvas getCanvas() {
        if (this.firstGame == this) {
            return super.getCanvas();
        }
        return this.firstGame.getCanvas();
    }

    public double getTime() {
        if (this.firstGame == this) {
            return super.getTime();
        }
        return this.firstGame.getTime();
    }

    public double getScreenRefreshRate() {
        if (this.firstGame == this) {
            return super.getScreenRefreshRate();
        }
        return this.firstGame.getScreenRefreshRate();
    }

    public void setMinimumModelFrameRate(int n) {
        if (this.firstGame == this) {
            super.setMinimumModelFrameRate(n);
        } else {
            this.firstGame.setMinimumModelFrameRate(n);
        }
    }

    public final void scheduleRelative(Alarm alarm, double d) {
        if (this.firstGame == this) {
            super.scheduleRelative(alarm, d);
        } else {
            this.firstGame.scheduleRelative(alarm, d);
        }
    }

    public final void scheduleAbsolute(Alarm alarm, double d) {
        if (this.firstGame == this) {
            super.scheduleAbsolute(alarm, d);
        } else {
            this.firstGame.scheduleAbsolute(alarm, d);
        }
    }

    public final void cancelAlarm(Alarm alarm) {
        if (this.firstGame == this) {
            super.cancelAlarm(alarm);
        } else {
            this.firstGame.cancelAlarm(alarm);
        }
    }

    public final void cancelAllAlarms() {
        if (this.firstGame == this) {
            super.cancelAllAlarms();
        } else {
            this.firstGame.cancelAllAlarms();
        }
    }

    public final Alarm[] getAlarms() {
        if (this.firstGame == this) {
            return super.getAlarms();
        }
        return this.firstGame.getAlarms();
    }

    public void schedule(AlarmAdapter alarmAdapter, double d) {
        if (this.firstGame == this) {
            super.schedule(alarmAdapter, d);
        } else {
            this.firstGame.schedule(alarmAdapter, d);
        }
    }

    public void cancel(AlarmAdapter alarmAdapter) {
        if (this.firstGame == this) {
            super.cancel(alarmAdapter);
        } else {
            this.firstGame.cancel(alarmAdapter);
        }
    }

    public void cancelAllTimedActions() {
        if (this.firstGame == this) {
            super.cancelAllTimedActions();
        } else {
            this.firstGame.cancelAllTimedActions();
        }
    }

    public AlarmAdapter[] getAllTimedActions() {
        if (this.firstGame == this) {
            return super.getAllTimedActions();
        }
        return this.firstGame.getAllTimedActions();
    }

    public void updateModel(double d) {
        if (this.firstGame == this && (this.firstGame != this.currentGame || this.activated)) {
            super.updateModel(d);
        } else if (this.activated) {
            this.firstGame.updateModel(d);
        }
    }

    public void setCursor(URL uRL) {
        if (this.firstGame == this) {
            super.setCursor(uRL);
        } else {
            this.firstGame.setCursor(uRL);
        }
    }

    public void removeCursor() {
        if (this.firstGame == this) {
            super.removeCursor();
        } else {
            this.firstGame.removeCursor();
        }
    }

    public void restoreCursor() {
        if (this.firstGame == this) {
            super.restoreCursor();
        } else {
            this.firstGame.restoreCursor();
        }
    }

    public final void refreshScreen() {
        if (this.firstGame == this) {
            super.refreshScreen();
        } else {
            this.firstGame.refreshScreen();
        }
    }

    public void resetTime() {
        if (this.firstGame == this) {
            super.resetTime();
        } else {
            this.firstGame.resetTime();
        }
    }

    public void runAsApplication() {
        if (this.firstGame == this) {
            super.runAsApplication();
        } else {
            this.firstGame.runAsApplication();
        }
    }

    public void setTitle(String string) {
        if (this.firstGame == this) {
            super.setTitle(string);
        } else {
            this.firstGame.setTitle(string);
        }
    }

    public void setHelp(String string) {
        if (this.firstGame == this) {
            super.setHelp(string);
        } else {
            this.firstGame.setHelp(string);
        }
    }

    public void setHelpText(String string) {
        if (this.firstGame == this) {
            super.setHelpText(string);
        } else {
            this.firstGame.setHelpText(string);
        }
    }
}

