/*
 * Decompiled with CFR 0.152.
 */
package fang2.core;

import fang2.core.Alarm;
import fang2.core.AlarmAdapter;
import fang2.core.AlarmScheduler;
import fang2.core.AnimationCanvas;
import fang2.core.Game;
import fang2.ui.ErrorConsole;
import fang2.ui.GameWindow;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.net.URL;
import java.util.LinkedList;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class FrameAdvancer
extends GameWindow
implements AlarmScheduler {
    protected static Game sharedCurrentGame;
    private final LinkedList<Double> refreshTimes;
    protected AnimationCanvas canvas;
    private double currentTime;
    private double timeOffset = 0.0;
    public double timeInterval;
    private double maxModelTimeInterval = 0.1;
    private final TreeMap<Double, LinkedList<Alarm>> alarms = new TreeMap();

    public FrameAdvancer() {
        this(AnimationCanvas.DEFAULT_SIZE, AnimationCanvas.DEFAULT_BACKGROUND);
    }

    public FrameAdvancer(Dimension dimension) {
        this(dimension, AnimationCanvas.DEFAULT_BACKGROUND);
    }

    public FrameAdvancer(Dimension dimension, Color color) {
        this.canvas = new AnimationCanvas(dimension, color);
        this.canvas.removeAllSprites();
        this.alarms.clear();
        this.refreshTimes = new LinkedList();
        for (int i = 0; i < 100; ++i) {
            this.refreshTimes.add(0.0);
        }
    }

    public void setBackground(Color color) {
        if (this.canvas != null) {
            this.canvas.setBackground(color);
        }
        super.setBackground(color);
    }

    public void setCanvas(AnimationCanvas animationCanvas) {
        this.canvas = animationCanvas;
    }

    public AnimationCanvas getCanvas() {
        return this.canvas;
    }

    public void advanceFrame(double d) {
    }

    public double getTime() {
        return this.currentTime - this.timeOffset;
    }

    public double getScreenRefreshRate() {
        return (double)(this.refreshTimes.size() - 1) / (this.refreshTimes.getLast() - this.refreshTimes.getFirst());
    }

    public void setMinimumModelFrameRate(int n) {
        if (n > 0) {
            this.maxModelTimeInterval = Math.max(0.005, 1.0 / (double)n);
        }
    }

    public void scheduleRelative(Alarm alarm, double d) {
        this.scheduleAbsolute(alarm, d + this.currentTime - this.timeOffset);
    }

    public void schedule(AlarmAdapter alarmAdapter, double d) {
        this.scheduleRelative(alarmAdapter, d);
    }

    public void scheduleAbsolute(Alarm alarm, double d) {
        LinkedList<Alarm> linkedList = this.alarms.get(d + this.timeOffset);
        if (linkedList == null) {
            linkedList = new LinkedList();
        }
        linkedList.add(alarm);
        this.alarms.put(d + this.timeOffset, linkedList);
    }

    public void cancelAlarm(Alarm alarm) {
        for (LinkedList<Alarm> linkedList : this.alarms.values()) {
            if (!linkedList.contains(alarm)) continue;
            linkedList.remove(alarm);
        }
    }

    public void cancel(AlarmAdapter alarmAdapter) {
        this.cancelAlarm(alarmAdapter);
    }

    public void cancelAllAlarms() {
        this.alarms.clear();
    }

    public void cancelAllTimedActions() {
        this.cancelAllAlarms();
    }

    public AlarmAdapter[] getAllTimedActions() {
        LinkedList<AlarmAdapter> linkedList = new LinkedList<AlarmAdapter>();
        for (LinkedList<Alarm> linkedList2 : this.alarms.values()) {
            for (Alarm alarm : linkedList2) {
                if (!(alarm instanceof AlarmAdapter)) continue;
                linkedList.add((AlarmAdapter)alarm);
            }
        }
        return linkedList.toArray(new AlarmAdapter[0]);
    }

    public Alarm[] getAlarms() {
        LinkedList<Alarm> linkedList = new LinkedList<Alarm>();
        for (LinkedList<Alarm> linkedList2 : this.alarms.values()) {
            linkedList.addAll(linkedList2);
        }
        return linkedList.toArray(new Alarm[0]);
    }

    protected void initializeCurrentGame() {
        sharedCurrentGame = this.getSharedCurrentGame();
    }

    protected Game getSharedCurrentGame() {
        return null;
    }

    public void updateModel(double d) {
        this.initializeCurrentGame();
        double d2 = d - this.currentTime;
        while (d2 > 0.0) {
            double d3 = Double.MAX_VALUE;
            if (!this.alarms.isEmpty()) {
                d3 = this.alarms.firstKey() - this.currentTime;
            }
            double d4 = Math.min(d2, this.maxModelTimeInterval);
            d4 = Math.min(d4, d3);
            if (this.alarms.size() > 0 && this.currentTime - this.alarms.firstKey() == d4) {
                LinkedList<Alarm> linkedList = this.alarms.remove(this.alarms.firstKey());
                for (Alarm alarm : linkedList) {
                    if (ErrorConsole.hasErrors()) continue;
                    alarm.act();
                }
            }
            if (!ErrorConsole.hasErrors()) {
                this.canvas.updateSprites(d4);
            }
            this.currentTime += d4;
            d2 -= d4;
            try {
                if (ErrorConsole.hasErrors()) continue;
                this.advanceFrame(d4);
                this.postAdvanceFrame(d4);
            }
            catch (Throwable throwable) {
                Container container = this.getContentPane();
                JPanel jPanel = new JPanel(new GridLayout(2, 1));
                jPanel.add(container);
                JTextArea jTextArea = new JTextArea();
                jTextArea.setText("Cannot advanceFrame!\n");
                jTextArea.append("Caused by Exception: " + throwable.toString() + "\n");
                for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                    jTextArea.append("\t" + stackTraceElement + "\n");
                }
                jPanel.add(new JScrollPane(jTextArea));
                this.setContentPane(jPanel);
                System.err.println("Error!");
                throwable.printStackTrace();
                ErrorConsole.addError("none", "none", throwable);
            }
        }
    }

    public void setCursor(URL uRL) {
        this.canvas.setCursor(uRL);
    }

    public void removeCursor() {
        this.canvas.removeCursor();
    }

    public void restoreCursor() {
        this.canvas.restoreCursor();
    }

    public abstract void postAdvanceFrame(double var1);

    public void refreshScreen() {
        this.refreshTimes.removeFirst();
        this.refreshTimes.addLast(this.currentTime);
        this.canvas.paintImmediately();
    }

    public void resetTime() {
        this.timeOffset = this.currentTime;
    }
}

