/*
 * Decompiled with CFR 0.152.
 */
package fang2.attributes;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Palette {
    private static Map<String, String> canonicalToFullnameMap;
    private static Map<String, Color> colorMap;
    private static Map<Color, String> colorToFullnameMap;
    public static final Color FANG_BLUE;
    public static String NO_SUCH_COLOR;
    public static final int COLOR_CHANNEL_MAX = 255;
    public static final int COLOR_CHANNEL_MIN = 0;
    public static final int OPAQUE = 255;

    public static void addColor(String string, Color color) {
        Color color2 = Palette.getColor(color, 255);
        String string2 = Palette.getCanonicalName(string);
        colorMap.put(string, color2);
        colorToFullnameMap.put(color2, string);
        canonicalToFullnameMap.put(string2, string);
    }

    public static void addColor(String string, String string2) {
        Palette.addColor(string, Palette.getColorFromRGB(string2, 255));
    }

    public static Color getColor(Color color, int n) {
        return Palette.getColor(color.getRed(), color.getGreen(), color.getBlue(), n);
    }

    public static Color getColor(int n, int n2, int n3) {
        return new Color(n, n2, n3, 255);
    }

    public static Color getColor(int n, int n2, int n3, int n4) {
        n = Math.min(255, Math.max(0, n));
        n2 = Math.min(255, Math.max(0, n2));
        n3 = Math.min(255, Math.max(0, n3));
        n4 = Math.min(255, Math.max(0, n4));
        return new Color(n, n2, n3, n4);
    }

    public static Color getColor(String string) {
        return Palette.getColor(string, 255);
    }

    public static Color getColor(String string, int n) {
        Color color = null;
        String string2 = Palette.getCanonicalName(string);
        if (canonicalToFullnameMap.containsKey(string2)) {
            String string3 = canonicalToFullnameMap.get(string2);
            color = colorMap.get(string3);
        }
        if (color == null) {
            color = FANG_BLUE;
        }
        return Palette.getColor(color, n);
    }

    public static Color getColorFromRGB(String string) {
        return Palette.getColorFromRGB(string, 255);
    }

    public static Color getColorFromRGB(String string, int n) {
        int n2 = Integer.parseInt(string.substring(1, 3), 16);
        int n3 = Integer.parseInt(string.substring(3, 5), 16);
        int n4 = Integer.parseInt(string.substring(5, 7), 16);
        return Palette.getColor(n2, n3, n4, n);
    }

    public static Color getColorFromRGBA(String string) {
        int n = Integer.parseInt(string.substring(7, 9), 16);
        return Palette.getColorFromRGB(string.substring(0, 7), n);
    }

    public static Map<String, Color> getColorMap() {
        return new TreeMap<String, Color>(colorMap);
    }

    public static String getColorName(Color color) {
        String string = colorToFullnameMap.get(color);
        if (string == null) {
            string = "[" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + "]";
        }
        if (color.getAlpha() != 255) {
            string = string + ":" + color.getAlpha();
        }
        return string;
    }

    public static String getColorName(int n, int n2, int n3) {
        return Palette.getColorName(new Color(n, n2, n3));
    }

    public static String getColorName(String string) {
        return Palette.getColorName(Palette.getColorFromRGB(string));
    }

    public static Color getRandomColor(Random random) {
        if (random != null) {
            return Palette.getColor(random.nextInt(256), random.nextInt(256), random.nextInt(256));
        }
        return null;
    }

    public static String getRGB(Color color) {
        return "#" + Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue());
    }

    public static String getRGBA(Color color) {
        return "#" + Integer.toHexString(color.getRed()) + Integer.toHexString(color.getGreen()) + Integer.toHexString(color.getBlue()) + Integer.toHexString(color.getAlpha());
    }

    private static String getCanonicalName(String string) {
        return string.toLowerCase().replaceAll("\\s", "");
    }

    static {
        NO_SUCH_COLOR = "Not Found.";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Alice Blue", "#F0F8FF");
        hashMap.put("Antique White", "#FAEBD7");
        hashMap.put("Aqua", "#00FFFF");
        hashMap.put("Aquamarine", "#7FFFD4");
        hashMap.put("Azure", "#F0FFFF");
        hashMap.put("Beige", "#F5F5DC");
        hashMap.put("Bisque", "#FFE4C4");
        hashMap.put("Black", "#000000");
        hashMap.put("Blanched Almond", "#FFEBCD");
        hashMap.put("Blue", "#0000FF");
        hashMap.put("Blue Violet", "#8A2BE2");
        hashMap.put("Brown", "#A52A2A");
        hashMap.put("Burlywood", "#DEB887");
        hashMap.put("Cadetblue", "#5F9EA0");
        hashMap.put("Chartreuse", "#7FFF00");
        hashMap.put("Chocolate", "#D2691E");
        hashMap.put("Coral", "#FF7F50");
        hashMap.put("Cornflower Blue", "#6495ED");
        hashMap.put("Cornsilk", "#FFF8DC");
        hashMap.put("Crimson", "#DC143C");
        hashMap.put("Cyan", "#00FFFF");
        hashMap.put("Dark Blue", "#00008B");
        hashMap.put("Dark Cyan", "#008B8B");
        hashMap.put("Dark Goldenrod", "#B8860B");
        hashMap.put("Dark Gray", "#A9A9A9");
        hashMap.put("Dark Green", "#006400");
        hashMap.put("Dark Khaki", "#BDB76B");
        hashMap.put("Dark Magenta", "#8B008B");
        hashMap.put("Dark Olive Green", "#556B2F");
        hashMap.put("Dark Orange", "#FF8C00");
        hashMap.put("Dark Orchid", "#9932CC");
        hashMap.put("Dark Red", "#8B0000");
        hashMap.put("Dark Salmon", "#E9967A");
        hashMap.put("Dark Sea Green", "#8FBC8F");
        hashMap.put("Dark Slate Blue", "#483D8B");
        hashMap.put("Dark Slate Gray", "#2F4F4F");
        hashMap.put("Dark Turquoise", "#00CED1");
        hashMap.put("Dark Violet", "#9400D3");
        hashMap.put("Deep Pink", "#FF1493");
        hashMap.put("Deep Sky Blue", "#00BFFF");
        hashMap.put("Dim Gray", "#696969");
        hashMap.put("Dim Grey", "#696969");
        hashMap.put("Dodger Blue", "#1E90FF");
        hashMap.put("Fire Brick", "#B22222");
        hashMap.put("Floral White", "#FFFAF0");
        hashMap.put("Forest Green", "#228B22");
        hashMap.put("Fuchsia", "#FF00FF");
        hashMap.put("Gainsboro", "#DCDCDC");
        hashMap.put("Ghost White", "#F8F8FF");
        hashMap.put("Gold", "#FFD700");
        hashMap.put("Goldenrod", "#DAA520");
        hashMap.put("Gray", "#808080");
        hashMap.put("Grey", "#808080");
        hashMap.put("Green", "#008000");
        hashMap.put("Green Yellow", "#ADFF2F");
        hashMap.put("Honey Dew", "#F0FFF0");
        hashMap.put("Hot Pink", "#FF69B4");
        hashMap.put("Indian Red", "#CD5C5C");
        hashMap.put("Indigo", "#4B0082");
        hashMap.put("Ivory", "#FFFFF0");
        hashMap.put("Khaki", "#F0E68C");
        hashMap.put("Lavender", "#E6E6FA");
        hashMap.put("Lavender Blush", "#FFF0F5");
        hashMap.put("Lawn Green", "#7CFC00");
        hashMap.put("Lemon Chiffon", "#FFFACD");
        hashMap.put("Light Blue", "#ADD8E6");
        hashMap.put("Light Coral", "#F08080");
        hashMap.put("Light Cyan", "#E0FFFF");
        hashMap.put("Light Goldenrod Yellow", "#FAFAD2");
        hashMap.put("Light Green", "#90EE90");
        hashMap.put("Light Grey", "#D3D3D3");
        hashMap.put("Light Gray", "#D3D3D3");
        hashMap.put("Light Pink", "#FFB6C1");
        hashMap.put("Light Salmon", "#FFA07A");
        hashMap.put("Light Sea Green", "#20B2AA");
        hashMap.put("Light Sky Blue", "#87CEFA");
        hashMap.put("Light Slate Gray", "#778899");
        hashMap.put("Light Slate Grey", "#778899");
        hashMap.put("Light Steel Blue", "#B0C4DE");
        hashMap.put("Light Yellow", "#FFFFE0");
        hashMap.put("Lime", "#00FF00");
        hashMap.put("Lime Green", "#32CD32");
        hashMap.put("Linen", "#FAF0E6");
        hashMap.put("Magenta", "#FF00FF");
        hashMap.put("Maroon", "#800000");
        hashMap.put("Medium Aquamarine", "#66CDAA");
        hashMap.put("Medium Blue", "#0000CD");
        hashMap.put("Medium Orchid", "#BA55D3");
        hashMap.put("Medium Purple", "#9370DB");
        hashMap.put("Medium Sea Green", "#3CB371");
        hashMap.put("Medium Slate Blue", "#7B68EE");
        hashMap.put("Medium Spring Green", "#00FA9A");
        hashMap.put("Medium Turquoise", "#48D1CC");
        hashMap.put("Medium Violet Red", "#C71585");
        hashMap.put("Midnight Blue", "#191970");
        hashMap.put("Mint Cream", "#F5FFFA");
        hashMap.put("Misty Rose", "#FFE4E1");
        hashMap.put("Moccasin", "#FFE4B5");
        hashMap.put("Navajo White", "#FFDEAD");
        hashMap.put("Navy", "#000080");
        hashMap.put("Old Lace", "#FDF5E6");
        hashMap.put("Olive", "#808000");
        hashMap.put("Olive Drab", "#6B8E23");
        hashMap.put("Orange", "#FFA500");
        hashMap.put("Orange Red", "#FF4500");
        hashMap.put("Orchid", "#DA70D6");
        hashMap.put("Pale Goldenrod", "#EEE8AA");
        hashMap.put("Pale Green", "#98FB98");
        hashMap.put("Pale Turquoise", "#AFEEEE");
        hashMap.put("Pale Violet Red", "#DB7093");
        hashMap.put("Papaya Whip", "#FFEFD5");
        hashMap.put("Peachpuff", "#FFDAB9");
        hashMap.put("Peru", "#CD853F");
        hashMap.put("Pink", "#FFC0CB");
        hashMap.put("Plum", "#DDA0DD");
        hashMap.put("Powder Blue", "#B0E0E6");
        hashMap.put("Purple", "#800080");
        hashMap.put("Red", "#FF0000");
        hashMap.put("Rosy Brown", "#BC8F8F");
        hashMap.put("Royal Blue", "#4169E1");
        hashMap.put("Saddle Brown", "#8B4513");
        hashMap.put("Salmon", "#FA8072");
        hashMap.put("Sandy Brown", "#F4A460");
        hashMap.put("Sea Green", "#2E8B57");
        hashMap.put("Seashell", "#FFF5EE");
        hashMap.put("Sienna", "#A0522D");
        hashMap.put("Silver", "#C0C0C0");
        hashMap.put("Sky Blue", "#87CEEB");
        hashMap.put("Slate Blue", "#6A5ACD");
        hashMap.put("Slate Gray", "#708090");
        hashMap.put("Slate Grey", "#708090");
        hashMap.put("Snow", "#FFFAFA");
        hashMap.put("Spring Green", "#00FF7F");
        hashMap.put("Steel Blue", "#4682B4");
        hashMap.put("Tan", "#D2B48C");
        hashMap.put("Teal", "#008080");
        hashMap.put("Thistle", "#D8BFD8");
        hashMap.put("Tomato", "#FF6347");
        hashMap.put("Turquoise", "#40E0D0");
        hashMap.put("Violet", "#EE82EE");
        hashMap.put("Wheat", "#F5DEB3");
        hashMap.put("White", "#FFFFFF");
        hashMap.put("White Smoke", "#F5F5F5");
        hashMap.put("Yellow", "#FFFF00");
        hashMap.put("Yellow Green", "#9ACD32");
        hashMap.put("FANG Blue", "#6464FF");
        hashMap.put("SCG Red", "#A62126");
        colorMap = new TreeMap<String, Color>();
        canonicalToFullnameMap = new HashMap<String, String>();
        colorToFullnameMap = new HashMap<Color, String>();
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            String string3 = Palette.getCanonicalName(string);
            Color color = Palette.getColorFromRGB(string2);
            colorMap.put(string, color);
            colorToFullnameMap.put(color, string);
            canonicalToFullnameMap.put(string3, string);
        }
        FANG_BLUE = colorMap.get("FANG Blue");
    }
}

