/*
 * Decompiled with CFR 0.152.
 */
package fang2.attributes;

import fang2.attributes.Box2D;
import fang2.attributes.Vector2D;
import fang2.core.Game;
import fang2.core.Sprite;
import java.awt.geom.Point2D;

public class Location2D
extends Point2D.Double {
    public Location2D() {
        this(0.0, 0.0);
    }

    public Location2D(double d, double d2) {
        super(d, d2);
    }

    public Location2D(Location2D location2D) {
        this(location2D.getX(), location2D.getY());
    }

    public Location2D(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public Location2D(Vector2D vector2D) {
        this(vector2D.getX(), vector2D.getY());
    }

    public static double componentMagnitude(Location2D location2D, Location2D location2D2) {
        double d = location2D2.getRadians();
        double d2 = location2D.getRadians();
        double d3 = location2D.getMagintude();
        return d3 * Math.cos(d2 - d);
    }

    public static Location2D componentVector(Location2D location2D, Location2D location2D2) {
        Location2D location2D3 = location2D2.normalize();
        double d = Location2D.componentMagnitude(location2D, location2D2);
        return new Location2D(location2D3.getX() * d, location2D3.getY() * d);
    }

    public static final Location2D randomLocation() {
        return Location2D.randomLocation(Game.getCurrentGame());
    }

    public static final Location2D randomLocation(Box2D box2D) {
        return Location2D.randomLocation(Game.getCurrentGame(), box2D.getMinX(), box2D.getMinY(), box2D.getMaxX(), box2D.getMaxY());
    }

    public static final Location2D randomLocation(double d, double d2, double d3, double d4) {
        return Location2D.randomLocation(Game.getCurrentGame(), d, d2, d3, d4);
    }

    public static final Location2D randomLocation(Game game) {
        return Location2D.randomLocation(game, 0.0, 0.0, 1.0, 1.0);
    }

    public static final Location2D randomLocation(Game game, Box2D box2D) {
        return Location2D.randomLocation(game, box2D.getMinX(), box2D.getMinY(), box2D.getMaxX(), box2D.getMaxY());
    }

    public static final Location2D randomLocation(Game game, double d, double d2, double d3, double d4) {
        return new Location2D(game.randomDouble(d, d3), game.randomDouble(d2, d4));
    }

    public Location2D add(Location2D location2D) {
        return new Location2D(this.x + location2D.x, this.y + location2D.y);
    }

    public Location2D add(Vector2D vector2D) {
        return new Location2D(this.x + vector2D.getX(), this.y + vector2D.getY());
    }

    public Location2D additiveInverse() {
        return new Location2D(-this.getX(), -this.getY());
    }

    public double distance(double d, double d2) {
        return super.distance(d, d2);
    }

    public double distance(Location2D location2D) {
        return super.distance(location2D);
    }

    public double distance(Sprite sprite) {
        return super.distance(sprite.getLocation());
    }

    public double dotProduct(Location2D location2D) {
        return this.getX() * location2D.getX() + this.getY() * location2D.getY();
    }

    public double getRadians() {
        return Math.atan2(this.getY(), this.getX());
    }

    public double getRevolutions() {
        return this.getRadians() / (Math.PI * 2);
    }

    public double getRotationDegrees() {
        return 360.0 * (this.getRadians() / (Math.PI * 2));
    }

    public double getX() {
        return super.getX();
    }

    public double getY() {
        return super.getY();
    }

    public boolean intersects(Box2D box2D) {
        return box2D.contains(this);
    }

    public boolean intersects(Sprite sprite) {
        return sprite.intersects(this);
    }

    public double getMagintude() {
        double d = this.dotProduct(this);
        return Math.sqrt(d);
    }

    public Location2D multiply(double d) {
        return new Location2D(this.x * d, this.y * d);
    }

    public Location2D normalize() {
        double d = this.getMagintude();
        return new Location2D(this.x / d, this.y / d);
    }

    public void setX(double d) {
        super.setLocation(d, this.getY());
    }

    public void setY(double d) {
        super.setLocation(this.getX(), d);
    }

    public Location2D subtract(Location2D location2D) {
        return new Location2D(this.getX() - location2D.getX(), this.getY() - location2D.getY());
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.getX() + ",y=" + this.getY() + "]";
    }
}

