/*
 * Decompiled with CFR 0.152.
 */
package fang2.attributes;

import fang2.attributes.Location2D;
import fang2.attributes.Size2D;
import fang2.core.Sprite;
import fang2.sprites.RectangleSprite;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Box2D {
    private double height;
    private double width;
    private double x;
    private double y;

    public Box2D() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Box2D(Box2D box2D) {
        this(box2D.getMinX(), box2D.getMinY(), box2D.getWidth(), box2D.getHeight());
    }

    public Box2D(double d, double d2, double d3, double d4) {
        this.setX(d + d3 / 2.0);
        this.setY(d2 + d4 / 2.0);
        this.setWidth(d3);
        this.setHeight(d4);
    }

    public Box2D(Location2D location2D, Size2D size2D) {
        this.setX(location2D.getX());
        this.setY(location2D.getY());
        this.setWidth(size2D.getWidth());
        this.setHeight(size2D.getHeight());
    }

    public Box2D(Rectangle2D rectangle2D) {
        this(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(Point2D point2D) {
        return this.getMinX() <= point2D.getX() && point2D.getX() <= this.getMaxX() && this.getMinY() <= point2D.getY() && point2D.getY() <= this.getMaxY();
    }

    public double getBottom() {
        return this.getMaxY();
    }

    public Location2D getCenter() {
        return new Location2D(this.getX(), this.getY());
    }

    public double getHeight() {
        return this.height;
    }

    public double getLeft() {
        return this.getMinX();
    }

    public double getMaxX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getMaxY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public double getMinX() {
        return this.getX() - this.getWidth() / 2.0;
    }

    public double getMinY() {
        return this.getY() - this.getHeight() / 2.0;
    }

    public double getRight() {
        return this.getMaxX();
    }

    public Size2D getSize() {
        return new Size2D(this.getWidth(), this.getHeight());
    }

    public double getTop() {
        return this.getMinY();
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public boolean intersects(Location2D location2D) {
        return this.contains(location2D);
    }

    public boolean intersects(Sprite sprite) {
        RectangleSprite rectangleSprite = new RectangleSprite(this.getWidth(), this.getHeight());
        rectangleSprite.setLocation(this.getX(), this.getY());
        return sprite.intersects(rectangleSprite);
    }

    public int outcode(double d, double d2) {
        return this.Rectangle2D().outcode(d, d2);
    }

    public int outcode(Point2D point2D) {
        return this.Rectangle2D().outcode(point2D);
    }

    public Rectangle2D Rectangle2D() {
        return new Rectangle2D.Double(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public void setWidth(double d) {
        this.width = d;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public String toString() {
        return this.getClass().getName() + "[x = " + this.getX() + ", y = " + this.getY() + "], " + "[w = " + this.getWidth() + ", h = " + this.getHeight() + "]";
    }
}

