/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd.ntree;

import org.miv.pherd.geom.Point3;
import org.miv.pherd.ntree.Anchor;
import org.miv.pherd.ntree.CellSpace;

public class OctreeCellSpace
extends CellSpace {
    protected Anchor C;

    public OctreeCellSpace(Anchor lo, Anchor hi) {
        super(lo, hi);
    }

    @Override
    public int getDivisions() {
        return 8;
    }

    @Override
    public CellSpace newSubCellSpace(int i) {
        if (this.C == null) {
            double cx = this.lo.x + (this.hi.x - this.lo.x) / 2.0;
            double cy = this.lo.y + (this.hi.y - this.lo.y) / 2.0;
            double cz = this.lo.z + (this.hi.z - this.lo.z) / 2.0;
            this.C = new Anchor(cx, cy, cz);
        }
        Anchor BLF1 = this.lo;
        Anchor TRB2 = this.hi;
        switch (i) {
            case 0: {
                return new OctreeCellSpace(BLF1, this.C);
            }
            case 1: {
                Anchor BRF1 = new Anchor(this.C.x, this.lo.y, this.lo.z);
                Anchor BRF2 = new Anchor(this.hi.x, this.C.y, this.C.z);
                return new OctreeCellSpace(BRF1, BRF2);
            }
            case 2: {
                Anchor TRF1 = new Anchor(this.C.x, this.C.y, this.lo.z);
                Anchor TRF2 = new Anchor(this.hi.x, this.hi.y, this.C.z);
                return new OctreeCellSpace(TRF1, TRF2);
            }
            case 3: {
                Anchor TLF1 = new Anchor(this.lo.x, this.C.y, this.lo.z);
                Anchor TLF2 = new Anchor(this.C.x, this.hi.y, this.C.z);
                return new OctreeCellSpace(TLF1, TLF2);
            }
            case 4: {
                Anchor BLB1 = new Anchor(this.lo.x, this.lo.y, this.C.z);
                Anchor BLB2 = new Anchor(this.C.x, this.C.y, this.hi.z);
                return new OctreeCellSpace(BLB1, BLB2);
            }
            case 5: {
                Anchor BRB1 = new Anchor(this.C.x, this.lo.y, this.C.z);
                Anchor BRB2 = new Anchor(this.hi.x, this.C.y, this.hi.z);
                return new OctreeCellSpace(BRB1, BRB2);
            }
            case 6: {
                return new OctreeCellSpace(this.C, TRB2);
            }
            case 7: {
                Anchor TLB1 = new Anchor(this.lo.x, this.C.y, this.C.z);
                Anchor TLB2 = new Anchor(this.C.x, this.hi.y, this.hi.z);
                return new OctreeCellSpace(TLB1, TLB2);
            }
        }
        throw new RuntimeException("invalid subcell space index '" + i + "' for oct tree");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.lo.x);
        sb.append(", ");
        sb.append(this.lo.y);
        sb.append(", ");
        sb.append(this.lo.z);
        sb.append(" -> ");
        sb.append(this.hi.x);
        sb.append(", ");
        sb.append(this.hi.y);
        sb.append(", ");
        sb.append(this.hi.z);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void resize(Point3 min, Point3 max) {
        super.resize(min, max);
        double cx = this.lo.x + (this.hi.x - this.lo.x) / 2.0;
        double cy = this.lo.y + (this.hi.y - this.lo.y) / 2.0;
        double cz = this.lo.z + (this.hi.z - this.lo.z) / 2.0;
        this.C = new Anchor(cx, cy, cz);
    }
}

