/*
 * Decompiled with CFR 0.152.
 */
package org.miv.pherd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.miv.pherd.IdAlreadyInUseException;
import org.miv.pherd.Particle;
import org.miv.pherd.ParticleBoxListener;
import org.miv.pherd.ntree.Cell;
import org.miv.pherd.ntree.CellData;
import org.miv.pherd.ntree.CellSpace;
import org.miv.pherd.ntree.NTree;

public class ParticleBox {
    protected HashMap<Object, Particle> particles = new HashMap();
    protected NTree tree;
    protected ArrayList<ParticleBoxListener> listeners = new ArrayList();
    protected int time = 0;

    public ParticleBox(int pmax, CellSpace universe, CellData rootData) {
        this.tree = new NTree(pmax, universe, rootData, this);
    }

    public Particle getParticle(Object id) {
        return this.particles.get(id);
    }

    public NTree getNTree() {
        return this.tree;
    }

    public int getParticleCount() {
        return this.particles.size();
    }

    public Iterator<Object> getParticleIdIterator() {
        return this.particles.keySet().iterator();
    }

    public void addParticle(Particle particle) throws IdAlreadyInUseException {
        this.tree.addParticle(particle);
        Particle p = this.particles.put(particle.getId(), particle);
        if (p != null && p != particle) {
            throw new IdAlreadyInUseException("a particle with the same identifier already exists (" + particle.getId() + ")");
        }
        particle.setBox(this);
        for (ParticleBoxListener listener : this.listeners) {
            listener.particleAdded(particle.getId(), particle.pos.x, particle.pos.y, particle.pos.z);
        }
        particle.inserted();
    }

    public Particle removeParticle(Object id) {
        Particle particle = this.particles.remove(id);
        if (particle != null) {
            particle.removed();
            for (ParticleBoxListener listener : this.listeners) {
                listener.particleRemoved(particle.getId());
            }
            this.tree.removeParticle(particle);
            particle.setBox(null);
        }
        return particle;
    }

    public void removeAllParticles() {
        for (Particle particle : this.particles.values()) {
            for (ParticleBoxListener listener : this.listeners) {
                listener.particleRemoved(particle.getId());
            }
            Cell cell = particle.getCell();
            this.tree.removeParticle(particle);
            assert (cell != null) : "removing a particle (" + particle.getId() + ") that is not in the tree, it has no cell";
            assert (!cell.hasParticle(particle)) : "the cell from which the particle was removed still contains the particle";
            particle.setBox(null);
        }
        this.particles.clear();
        assert (this.tree.getRootCell().getPopulation() == 0) : "after remove all particles, the mama cell strill contains " + this.tree.getRootCell().getPopulation() + " particles";
    }

    public void step() {
        for (Particle particle : this.particles.values()) {
            particle.move(this.time);
        }
        for (Particle particle : this.particles.values()) {
            particle.nextStep(this.time);
        }
        this.tree.checkDivisions();
        for (ParticleBoxListener listener : this.listeners) {
            listener.stepFinished(this.time);
        }
        ++this.time;
    }

    public void addParticleBoxListener(ParticleBoxListener listener) {
        this.listeners.add(listener);
    }

    public void removeParticleBoxListener(ParticleBoxListener listener) {
        int i = this.listeners.indexOf(listener);
        if (i >= 0) {
            this.listeners.remove(i);
        }
    }
}

