/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.util.time;

import java.text.ParseException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graphstream.util.time.ISODateComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISODateIO {
    private static final ISODateComponent[] KNOWN_COMPONENTS = new ISODateComponent[]{ISODateComponent.ABBREVIATED_WEEKDAY_NAME, ISODateComponent.FULL_WEEKDAY_NAME, ISODateComponent.ABBREVIATED_MONTH_NAME, ISODateComponent.FULL_MONTH_NAME, ISODateComponent.LOCALE_DATE_AND_TIME, ISODateComponent.CENTURY, ISODateComponent.DAY_OF_MONTH_2_DIGITS, ISODateComponent.DATE, ISODateComponent.DAY_OF_MONTH, ISODateComponent.DATE_ISO8601, ISODateComponent.WEEK_BASED_YEAR_2_DIGITS, ISODateComponent.WEEK_BASED_YEAR_4_DIGITS, ISODateComponent.ABBREVIATED_MONTH_NAME_ALIAS, ISODateComponent.HOUR_OF_DAY, ISODateComponent.HOUR, ISODateComponent.DAY_OF_YEAR, ISODateComponent.MILLISECOND, ISODateComponent.EPOCH, ISODateComponent.MONTH, ISODateComponent.MINUTE, ISODateComponent.NEW_LINE, ISODateComponent.AM_PM, ISODateComponent.LOCALE_CLOCK_TIME_12_HOUR, ISODateComponent.HOUR_AND_MINUTE, ISODateComponent.SECOND, ISODateComponent.TABULATION, ISODateComponent.TIME_ISO8601, ISODateComponent.DAY_OF_WEEK_1_7, ISODateComponent.WEEK_OF_YEAR_FROM_SUNDAY, ISODateComponent.WEEK_NUMBER_ISO8601, ISODateComponent.DAY_OF_WEEK_0_6, ISODateComponent.WEEK_OF_YEAR_FROM_MONDAY, ISODateComponent.LOCALE_DATE_REPRESENTATION, ISODateComponent.LOCALE_TIME_REPRESENTATION, ISODateComponent.YEAR_2_DIGITS, ISODateComponent.YEAR_4_DIGITS, ISODateComponent.UTC_OFFSET, ISODateComponent.LOCALE_TIME_ZONE_NAME, ISODateComponent.PERCENT};
    protected LinkedList<ISODateComponent> components;
    protected Pattern pattern;

    public ISODateIO() throws ParseException {
        this("%K");
    }

    public ISODateIO(String format) throws ParseException {
        this.setFormat(format);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    protected LinkedList<ISODateComponent> findComponents(String format) throws ParseException {
        LinkedList<ISODateComponent> components = new LinkedList<ISODateComponent>();
        int offset = 0;
        while (offset < format.length()) {
            if (format.charAt(offset) == '%') {
                boolean found = false;
                for (int i = 0; !found && i < KNOWN_COMPONENTS.length; ++i) {
                    if (!format.startsWith(KNOWN_COMPONENTS[i].getDirective(), offset)) continue;
                    found = true;
                    if (KNOWN_COMPONENTS[i].isAlias()) {
                        LinkedList<ISODateComponent> sub = this.findComponents(KNOWN_COMPONENTS[i].getReplacement());
                        components.addAll(sub);
                    } else {
                        components.addLast(KNOWN_COMPONENTS[i]);
                    }
                    offset += KNOWN_COMPONENTS[i].getDirective().length();
                }
                if (found) continue;
                throw new ParseException("unknown identifier", offset);
            }
            int from = offset;
            while (offset < format.length() && format.charAt(offset) != '%') {
                ++offset;
            }
            components.addLast(new ISODateComponent.TextComponent(format.substring(from, offset)));
        }
        return components;
    }

    protected void buildRegularExpression() {
        String pattern = "";
        for (int i = 0; i < this.components.size(); ++i) {
            ISODateComponent c = this.components.get(i);
            String regexValue = c instanceof ISODateComponent ? c.getReplacement() : c.toString();
            pattern = pattern + "(" + regexValue + ")";
        }
        this.pattern = Pattern.compile(pattern);
    }

    public void setFormat(String format) throws ParseException {
        this.components = this.findComponents(format);
        this.buildRegularExpression();
    }

    public Calendar parse(String time) {
        Calendar cal = Calendar.getInstance();
        Matcher match = this.pattern.matcher(time);
        if (match.matches()) {
            for (int i = 0; i < this.components.size(); ++i) {
                this.components.get(i).set(match.group(i + 1), cal);
            }
        } else {
            return null;
        }
        return cal;
    }

    public String toString(Calendar calendar) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.components.size(); ++i) {
            buffer.append(this.components.get(i).get(calendar));
        }
        return buffer.toString();
    }
}

