/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.util;

import java.awt.event.KeyEvent;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.swingViewer.View;
import org.graphstream.ui.swingViewer.util.Camera;
import org.graphstream.ui.swingViewer.util.ShortcutManager;

public class DefaultShortcutManager
implements ShortcutManager {
    protected View view;
    protected double viewPercent = 1.0;
    protected Point3 viewPos = new Point3();
    protected double rotation = 0.0;

    public void init(GraphicGraph graph, View view) {
        this.view = view;
        view.addKeyListener(this);
    }

    public void release() {
        this.view.removeKeyListener(this);
    }

    public void keyPressed(KeyEvent event) {
        Camera camera = this.view.getCamera();
        if (event.getKeyCode() == 33) {
            camera.setViewPercent(Math.max((double)1.0E-4f, camera.getViewPercent() * (double)0.9f));
        } else if (event.getKeyCode() == 34) {
            camera.setViewPercent(camera.getViewPercent() * (double)1.1f);
        } else if (event.getKeyCode() == 37) {
            if ((event.getModifiers() & 8) != 0) {
                double r = camera.getViewRotation();
                camera.setViewRotation(r - 5.0);
            } else {
                double delta = 0.0;
                delta = (event.getModifiers() & 1) != 0 ? camera.getGraphDimension() * (double)0.1f : camera.getGraphDimension() * (double)0.01f;
                Point3 p = camera.getViewCenter();
                camera.setViewCenter(p.x - (delta *= camera.getViewPercent()), p.y, 0.0);
            }
        } else if (event.getKeyCode() == 39) {
            if ((event.getModifiers() & 8) != 0) {
                double r = camera.getViewRotation();
                camera.setViewRotation(r + 5.0);
            } else {
                double delta = 0.0;
                delta = (event.getModifiers() & 1) != 0 ? camera.getGraphDimension() * (double)0.1f : camera.getGraphDimension() * (double)0.01f;
                Point3 p = camera.getViewCenter();
                camera.setViewCenter(p.x + (delta *= camera.getViewPercent()), p.y, 0.0);
            }
        } else if (event.getKeyCode() == 38) {
            double delta = 0.0;
            delta = (event.getModifiers() & 1) != 0 ? camera.getGraphDimension() * (double)0.1f : camera.getGraphDimension() * (double)0.01f;
            Point3 p = camera.getViewCenter();
            camera.setViewCenter(p.x, p.y + (delta *= camera.getViewPercent()), 0.0);
        } else if (event.getKeyCode() == 40) {
            double delta = 0.0;
            delta = (event.getModifiers() & 1) != 0 ? camera.getGraphDimension() * (double)0.1f : camera.getGraphDimension() * (double)0.01f;
            Point3 p = camera.getViewCenter();
            camera.setViewCenter(p.x, p.y - (delta *= camera.getViewPercent()), 0.0);
        }
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        if (event.getKeyChar() == 'R') {
            this.view.getCamera().resetView();
        }
    }
}

