/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer.basicRenderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import org.graphstream.ui.geom.Vector2;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicElement;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.swingViewer.basicRenderer.ElementRenderer;
import org.graphstream.ui.swingViewer.util.Camera;

public class EdgeRenderer
extends ElementRenderer {
    protected Line2D shape = new Line2D.Double();
    protected double width = 1.0;
    protected double arrowLength = 0.0;
    protected double arrowWidth = 0.0;

    protected void setupRenderingPass(StyleGroup group, Graphics2D g, Camera camera) {
        this.configureText(group, camera);
    }

    protected void pushDynStyle(StyleGroup group, Graphics2D g, Camera camera, GraphicElement element) {
        Color color = group.getFillColor(0);
        if (element != null && group.getFillMode() == StyleConstants.FillMode.DYN_PLAIN) {
            color = this.interpolateColor(group, element);
        }
        g.setColor(color);
        if (group.getSizeMode() == StyleConstants.SizeMode.DYN_SIZE) {
            this.width = camera.getMetrics().lengthToGu(StyleConstants.convertValue(element.getAttribute("ui.size")));
            g.setStroke(new BasicStroke((float)this.width, 0, 2));
        }
    }

    protected void pushStyle(StyleGroup group, Graphics2D g, Camera camera) {
        this.width = camera.getMetrics().lengthToGu(group.getSize(), 0);
        this.arrowLength = camera.getMetrics().lengthToGu(group.getArrowSize(), 0);
        this.arrowWidth = camera.getMetrics().lengthToGu(group.getArrowSize(), group.getArrowSize().size() > 1 ? 1 : 0);
        g.setColor(group.getFillColor(0));
        g.setStroke(new BasicStroke((float)this.width, 0, 2));
    }

    protected void elementInvisible(StyleGroup group, Graphics2D g, Camera camera, GraphicElement element) {
    }

    protected void renderElement(StyleGroup group, Graphics2D g, Camera camera, GraphicElement element) {
        GraphicEdge edge = (GraphicEdge)element;
        GraphicNode node0 = (GraphicNode)edge.getNode0();
        GraphicNode node1 = (GraphicNode)edge.getNode1();
        this.shape.setLine(node0.x, node0.y, node1.x, node1.y);
        g.draw(this.shape);
        this.renderArrow(group, g, camera, edge);
        this.renderText(group, g, camera, element);
    }

    protected void renderArrow(StyleGroup group, Graphics2D g, Camera camera, GraphicEdge edge) {
        if (edge.isDirected() && this.arrowWidth > 0.0 && this.arrowLength > 0.0 && group.getArrowShape() != StyleConstants.ArrowShape.NONE) {
            Path2D.Double shape = new Path2D.Double();
            GraphicNode node0 = (GraphicNode)edge.getNode0();
            GraphicNode node1 = (GraphicNode)edge.getNode1();
            double off = this.evalEllipseRadius(edge, node0, node1, camera);
            Vector2 theDirection = new Vector2(node1.getX() - node0.getX(), node1.getY() - node0.getY());
            theDirection.normalize();
            double x = node1.x - theDirection.data[0] * off;
            double y = node1.y - theDirection.data[1] * off;
            Vector2 perp = new Vector2(theDirection.data[1], -theDirection.data[0]);
            perp.normalize();
            theDirection.scalarMult(this.arrowLength);
            perp.scalarMult(this.arrowWidth);
            shape.reset();
            ((Path2D)shape).moveTo(x, y);
            ((Path2D)shape).lineTo(x - theDirection.data[0] + perp.data[0], y - theDirection.data[1] + perp.data[1]);
            ((Path2D)shape).lineTo(x - theDirection.data[0] - perp.data[0], y - theDirection.data[1] - perp.data[1]);
            shape.closePath();
            g.fill(shape);
        }
    }

    protected double evalEllipseRadius(GraphicEdge edge, GraphicNode node0, GraphicNode node1, Camera camera) {
        double h;
        Values size = node1.getStyle().getSize();
        double w = camera.getMetrics().lengthToGu(size.get(0), size.getUnits());
        double d = h = size.size() > 1 ? camera.getMetrics().lengthToGu(size.get(1), size.getUnits()) : w;
        if ((w /= 2.0) == (h /= 2.0)) {
            return w;
        }
        double dx = node1.getX() - node0.getX();
        double dy = node1.getY() - node0.getY();
        double d2 = Math.sqrt(dx * dx + (dy *= w / h) * dy);
        double a = dx / d2;
        a = Math.acos(a);
        dx = Math.cos(a) * w;
        dy = Math.sin(a) * h;
        return Math.sqrt(dx * dx + dy * dy);
    }
}

