/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.swingViewer;

import java.util.HashSet;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.SourceBase;
import org.graphstream.ui.swingViewer.ViewerListener;

public class ViewerPipe
extends SourceBase
implements ProxyPipe {
    private String id;
    protected ProxyPipe pipeIn;
    protected HashSet<ViewerListener> viewerListeners = new HashSet();

    protected ViewerPipe(String id, ProxyPipe pipeIn) {
        this.id = id;
        this.pipeIn = pipeIn;
        pipeIn.addSink(this);
    }

    public String getId() {
        return this.id;
    }

    public void pump() {
        this.pipeIn.pump();
    }

    public void blockingPump() throws InterruptedException {
        this.pipeIn.blockingPump();
    }

    public void blockingPump(long timeout) throws InterruptedException {
        this.pipeIn.blockingPump(timeout);
    }

    public void addViewerListener(ViewerListener listener) {
        this.viewerListeners.add(listener);
    }

    public void removeViewerListener(ViewerListener listener) {
        this.viewerListeners.remove(listener);
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.sendEdgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.sendEdgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.sendEdgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.sendGraphAttributeAdded(sourceId, timeId, attribute, value);
        if (attribute.equals("ui.viewClosed") && value instanceof String) {
            for (ViewerListener listener : this.viewerListeners) {
                listener.viewClosed((String)value);
            }
            this.sendGraphAttributeRemoved(this.id, attribute);
        } else if (attribute.equals("ui.clicked") && value instanceof String) {
            for (ViewerListener listener : this.viewerListeners) {
                listener.buttonPushed((String)value);
            }
            this.sendGraphAttributeRemoved(this.id, attribute);
        }
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.sendGraphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.sendGraphAttributeRemoved(sourceId, timeId, attribute);
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.sendNodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
        if (attribute.equals("ui.clicked")) {
            for (ViewerListener listener : this.viewerListeners) {
                listener.buttonPushed(nodeId);
            }
        }
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.sendNodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.sendNodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
        if (attribute.equals("ui.clicked")) {
            for (ViewerListener listener : this.viewerListeners) {
                listener.buttonReleased(nodeId);
            }
        }
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.sendEdgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.sendEdgeRemoved(sourceId, timeId, edgeId);
    }

    public void graphCleared(String sourceId, long timeId) {
        this.sendGraphCleared(sourceId, timeId);
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.sendNodeAdded(sourceId, timeId, nodeId);
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.sendNodeRemoved(sourceId, timeId, nodeId);
    }

    public void stepBegins(String sourceId, long timeId, double step) {
        this.sendStepBegins(sourceId, timeId, step);
    }
}

