/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.spriteManager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.graphstream.graph.Element;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.spriteManager.SpriteManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sprite
implements Element {
    protected String id;
    protected String completeId;
    protected SpriteManager manager;
    protected Values position;
    protected Element attachment;

    protected Sprite() {
    }

    protected Sprite(String id, SpriteManager manager) {
        this(id, manager, null);
    }

    protected Sprite(String id, SpriteManager manager, Values position) {
        this.init(id, manager, position);
    }

    protected void init(String id, SpriteManager manager, Values position) {
        this.id = id;
        this.completeId = String.format("ui.sprite.%s", id);
        this.manager = manager;
        if (!manager.graph.hasAttribute(this.completeId)) {
            if (position != null) {
                manager.graph.addAttribute(this.completeId, position);
                this.position = position;
            } else {
                this.position = new Values(StyleConstants.Units.GU, 0.0, 0.0, 0.0);
                manager.graph.addAttribute(this.completeId, this.position);
            }
        } else if (position != null) {
            manager.graph.setAttribute(this.completeId, position);
            this.position = position;
        } else {
            this.position = SpriteManager.getPositionValue(manager.graph.getAttribute(this.completeId));
        }
    }

    protected void removed() {
        this.manager.graph.removeAttribute(this.completeId);
        String start = String.format("%s.", this.completeId);
        if (this.attached()) {
            this.detach();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.manager.graph.getAttributeKeySet()) {
            if (!key.startsWith(start)) continue;
            keys.add(key);
        }
        for (String key : keys) {
            this.manager.graph.removeAttribute(key);
        }
    }

    public Element getAttachment() {
        return this.attachment;
    }

    public boolean attached() {
        return this.attachment != null;
    }

    public double getX() {
        if (this.position.values.size() > 0) {
            return this.position.values.get(0);
        }
        return 0.0;
    }

    public double getY() {
        if (this.position.values.size() > 1) {
            return this.position.values.get(1);
        }
        return 0.0;
    }

    public double getZ() {
        if (this.position.values.size() > 2) {
            return this.position.values.get(2);
        }
        return 0.0;
    }

    public StyleConstants.Units getUnits() {
        return this.position.units;
    }

    public void attachToNode(String id) {
        if (this.attachment != null) {
            this.detach();
        }
        this.attachment = this.manager.graph.getNode(id);
        if (this.attachment != null) {
            this.attachment.addAttribute(this.completeId, new Object[0]);
        }
    }

    public void attachToEdge(String id) {
        if (this.attachment != null) {
            this.detach();
        }
        this.attachment = this.manager.graph.getEdge(id);
        if (this.attachment != null) {
            this.attachment.addAttribute(this.completeId, new Object[0]);
        }
    }

    public void detach() {
        if (this.attachment != null) {
            this.attachment.removeAttribute(this.completeId);
            this.attachment = null;
        }
    }

    public void setPosition(double percent) {
        this.setPosition(this.position.units, percent, 0.0, 0.0);
    }

    public void setPosition(double x, double y, double z) {
        this.setPosition(this.position.units, x, y, z);
    }

    public void setPosition(StyleConstants.Units units, double x, double y, double z) {
        boolean changed = false;
        if (this.position.get(0) != x) {
            changed = true;
            this.position.setValue(0, x);
        }
        if (this.position.get(1) != y) {
            changed = true;
            this.position.setValue(1, y);
        }
        if (this.position.get(2) != z) {
            changed = true;
            this.position.setValue(2, z);
        }
        if (this.position.units != units) {
            changed = true;
            this.position.setUnits(units);
        }
        if (changed) {
            this.manager.graph.setAttribute(this.completeId, new Values(this.position));
        }
    }

    protected void setPosition(Values values) {
        if (values != null) {
            int n = values.values.size();
            if (n > 2) {
                this.setPosition(values.units, values.get(0), values.get(1), values.get(2));
            } else if (n > 0) {
                this.setPosition(values.get(0));
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public CharSequence getLabel(String key) {
        return this.manager.graph.getLabel(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public <T> T getAttribute(String key) {
        return this.manager.graph.getAttribute(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public <T> T getAttribute(String key, Class<T> clazz) {
        return this.manager.graph.getAttribute(String.format("%s.%s", this.completeId, key), clazz);
    }

    @Override
    public int getAttributeCount() {
        String start = String.format("%s.", this.completeId);
        int count = 0;
        for (String key : this.manager.graph.getAttributeKeySet()) {
            if (!key.startsWith(start)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<String> getAttributeKeyIterator() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public Iterable<String> getEachAttributeKey() {
        return this.getAttributeKeySet();
    }

    @Override
    public Collection<String> getAttributeKeySet() {
        throw new RuntimeException("not implemented");
    }

    public Map<String, Object> getAttributeMap() {
        throw new RuntimeException("not implemented");
    }

    @Override
    public <T> T getFirstAttributeOf(String ... keys) {
        String[] completeKeys = new String[keys.length];
        int i = 0;
        for (String key : keys) {
            completeKeys[i] = String.format("%s.%s", this.completeId, key);
            ++i;
        }
        return this.manager.graph.getFirstAttributeOf(completeKeys);
    }

    @Override
    public <T> T getFirstAttributeOf(Class<T> clazz, String ... keys) {
        String[] completeKeys = new String[keys.length];
        int i = 0;
        for (String key : keys) {
            completeKeys[i] = String.format("%s.%s", this.completeId, key);
            ++i;
        }
        return this.manager.graph.getFirstAttributeOf(clazz, completeKeys);
    }

    @Override
    public Object[] getArray(String key) {
        return this.manager.graph.getArray(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public HashMap<?, ?> getHash(String key) {
        return this.manager.graph.getHash(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public double getNumber(String key) {
        return this.manager.graph.getNumber(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public ArrayList<? extends Number> getVector(String key) {
        return this.manager.graph.getVector(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasAttribute(String key) {
        return this.manager.graph.hasAttribute(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasArray(String key) {
        return this.manager.graph.hasArray(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasAttribute(String key, Class<?> clazz) {
        return this.manager.graph.hasAttribute(String.format("%s.%s", this.completeId, key), clazz);
    }

    @Override
    public boolean hasHash(String key) {
        return this.manager.graph.hasHash(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasLabel(String key) {
        return this.manager.graph.hasLabel(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasNumber(String key) {
        return this.manager.graph.hasNumber(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public boolean hasVector(String key) {
        return this.manager.graph.hasVector(String.format("%s.%s", this.completeId, key));
    }

    @Override
    public void addAttribute(String attribute, Object ... values) {
        this.manager.graph.addAttribute(String.format("%s.%s", this.completeId, attribute), values);
    }

    @Override
    public void addAttributes(Map<String, Object> attributes) {
        for (String key : attributes.keySet()) {
            this.manager.graph.addAttribute(String.format("%s.%s", this.completeId, key), attributes.get(key));
        }
    }

    @Override
    public void setAttribute(String attribute, Object ... values) {
        this.manager.graph.setAttribute(String.format("%s.%s", this.completeId, attribute), values);
    }

    @Override
    public void changeAttribute(String attribute, Object ... values) {
        this.manager.graph.changeAttribute(String.format("%s.%s", this.completeId, attribute), values);
    }

    @Override
    public void clearAttributes() {
        String start = String.format("%s.", this.completeId);
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.manager.graph.getAttributeKeySet()) {
            if (!key.startsWith(start)) continue;
            keys.add(key);
        }
        for (String key : keys) {
            this.manager.graph.removeAttribute(key);
        }
    }

    @Override
    public void removeAttribute(String attribute) {
        this.manager.graph.removeAttribute(String.format("%s.%s", this.completeId, attribute));
    }

    @Override
    public int getIndex() {
        return 0;
    }
}

