/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout.springbox.implementations;

import java.util.Random;
import org.graphstream.ui.layout.springbox.BarnesHutLayout;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.graphstream.ui.layout.springbox.implementations.LinLogNodeParticle;

public class LinLog
extends BarnesHutLayout {
    protected double k = 1.0;
    protected double aFactor = 1.0;
    protected double rFactor = 1.0;
    protected boolean edgeBased = true;
    protected double maxR = 0.5;
    protected double a = 0.0;
    protected double r = -1.2;

    public LinLog() {
        this(false);
    }

    public LinLog(boolean is3D) {
        this(is3D, new Random(System.currentTimeMillis()));
    }

    public LinLog(boolean is3D, Random randomNumberGenerator) {
        super(is3D, randomNumberGenerator);
        this.setQuality(1.0);
        this.force = 3.0;
    }

    public void configure(double a, double r, boolean edgeBased, double force) {
        this.a = a;
        this.r = r;
        this.edgeBased = edgeBased;
        this.force = force;
    }

    public String getLayoutAlgorithmName() {
        return "LinLog";
    }

    public void setQuality(double qualityLevel) {
        super.setQuality(qualityLevel);
        this.viewZone = this.quality >= 1.0 ? -1.0 : this.k;
    }

    public void compute() {
        if (this.viewZone > 0.0) {
            this.viewZone = this.area / 1.5;
        }
        super.compute();
    }

    protected void chooseNodePosition(NodeParticle n0, NodeParticle n1) {
    }

    public NodeParticle newNodeParticle(String id) {
        return new LinLogNodeParticle(this, id);
    }
}

