/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout.springbox;

import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.graphstream.ui.geom.Vector3;
import org.graphstream.ui.layout.springbox.BarnesHutLayout;
import org.graphstream.ui.layout.springbox.EdgeSpring;
import org.miv.pherd.Particle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeParticle
extends Particle {
    public ArrayList<EdgeSpring> neighbours = new ArrayList();
    public boolean frozen = false;
    public Vector3 disp;
    public double len;
    public double attE;
    public double repE;
    public PrintStream out;
    protected BarnesHutLayout box;

    public NodeParticle(BarnesHutLayout box, String id) {
        this(box, id, box.randomXInsideBounds(), box.randomYInsideBounds(), box.is3D ? box.randomZInsideBounds() : 0.0);
        this.box = box;
    }

    public NodeParticle(BarnesHutLayout box, String id, double x, double y, double z) {
        super(id, x, y, box.is3D ? z : 0.0);
        this.box = box;
        this.disp = new Vector3();
        this.createDebug();
    }

    protected void createDebug() {
        if (this.box.outputNodeStats) {
            try {
                this.out = new PrintStream(new FileOutputStream("out" + this.getId() + ".data"));
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    public Collection<EdgeSpring> getEdges() {
        return this.neighbours;
    }

    @Override
    public void move(int time) {
        if (!this.frozen) {
            this.disp.fill(0.0);
            Vector3 delta = new Vector3();
            this.repE = 0.0;
            this.attE = 0.0;
            if (this.box.viewZone < 0.0) {
                this.repulsionN2(delta);
            } else {
                this.repulsionNLogN(delta);
            }
            this.attraction(delta);
            if (this.box.gravity != 0.0) {
                this.gravity(delta);
            }
            this.disp.scalarMult(this.box.force);
            this.len = this.disp.length();
            if (this.len > this.box.area / 2.0) {
                this.disp.scalarMult(this.box.area / 2.0 / this.len);
                this.len = this.box.area / 2.0;
            }
            this.box.avgLength += this.len;
            if (this.len > this.box.maxMoveLength) {
                this.box.maxMoveLength = this.len;
            }
        }
    }

    @Override
    public void nextStep(int time) {
        if (!this.frozen) {
            this.nextPos.x = this.pos.x + this.disp.data[0];
            this.nextPos.y = this.pos.y + this.disp.data[1];
            if (this.box.is3D) {
                this.nextPos.z = this.pos.z + this.disp.data[2];
            }
            ++this.box.nodeMoveCount;
            this.moved = true;
        } else {
            this.nextPos.x = this.pos.x;
            this.nextPos.y = this.pos.y;
            if (this.box.is3D) {
                this.nextPos.z = this.pos.z;
            }
        }
        if (this.out != null) {
            this.out.printf(Locale.US, "%s %f %f %f%n", this.getId(), this.len, this.attE, this.repE);
            this.out.flush();
        }
        super.nextStep(time);
    }

    public void moveOf(double dx, double dy, double dz) {
        this.pos.set(this.pos.x + dx, this.pos.y + dy, this.pos.z + dz);
    }

    public void moveTo(double x, double y, double z) {
        this.pos.set(x, y, z);
        this.moved = true;
    }

    protected abstract void repulsionN2(Vector3 var1);

    protected abstract void repulsionNLogN(Vector3 var1);

    protected abstract void attraction(Vector3 var1);

    protected abstract void gravity(Vector3 var1);

    public void registerEdge(EdgeSpring e) {
        this.neighbours.add(e);
    }

    public void unregisterEdge(EdgeSpring e) {
        int i = this.neighbours.indexOf(e);
        if (i >= 0) {
            this.neighbours.remove(i);
        }
    }

    public void removeNeighborEdges() {
        ArrayList<EdgeSpring> edges = new ArrayList<EdgeSpring>(this.neighbours);
        for (EdgeSpring edge : edges) {
            this.box.removeEdge(this.box.getLayoutAlgorithmName(), edge.id);
        }
        this.neighbours.clear();
    }

    @Override
    public void inserted() {
    }

    @Override
    public void removed() {
    }
}

