/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout.springbox;

import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Random;
import org.graphstream.stream.SourceBase;
import org.graphstream.stream.sync.SinkTime;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphPosLengthUtils;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.springbox.EdgeSpring;
import org.graphstream.ui.layout.springbox.Energies;
import org.graphstream.ui.layout.springbox.GraphCellData;
import org.graphstream.ui.layout.springbox.NodeParticle;
import org.miv.pherd.ParticleBox;
import org.miv.pherd.ParticleBoxListener;
import org.miv.pherd.ntree.Anchor;
import org.miv.pherd.ntree.CellSpace;
import org.miv.pherd.ntree.OctreeCellSpace;
import org.miv.pherd.ntree.QuadtreeCellSpace;

public abstract class BarnesHutLayout
extends SourceBase
implements Layout,
ParticleBoxListener {
    protected ParticleBox nodes;
    protected HashMap<String, EdgeSpring> edges = new HashMap();
    protected int lastElementCount = 0;
    protected Random random;
    protected Point3 lo = new Point3(0.0, 0.0, 0.0);
    protected Point3 hi = new Point3(1.0, 1.0, 1.0);
    protected Point3 center = new Point3(0.5, 0.5, 0.5);
    protected PrintStream statsOut;
    protected Energies energies = new Energies();
    protected double force = 1.0;
    protected double viewZone = 5.0;
    protected double theta = 0.7f;
    protected double quality = 1.0;
    protected int nodesPerCell = 10;
    protected double area = 1.0;
    protected double stabilizationLimit = 0.9;
    protected int time;
    protected long lastStepTime;
    protected double maxMoveLength;
    protected double avgLength;
    protected int nodeMoveCount;
    protected boolean is3D = false;
    protected double gravity = 0.0;
    protected boolean sendNodeInfos = false;
    protected boolean outputStats = false;
    protected boolean outputNodeStats = false;
    protected int sendMoveEventsEvery = 1;
    protected SinkTime sinkTime;

    public BarnesHutLayout() {
        this(false);
    }

    public BarnesHutLayout(boolean is3D) {
        this(is3D, new Random(System.currentTimeMillis()));
    }

    public BarnesHutLayout(boolean is3D, Random randomNumberGenerator) {
        this.is3D = is3D;
        this.random = randomNumberGenerator;
        CellSpace space = is3D ? new OctreeCellSpace(new Anchor(-1.0, -1.0, -1.0), new Anchor(1.0, 1.0, 1.0)) : new QuadtreeCellSpace(new Anchor(-1.0, -1.0, -0.01f), new Anchor(1.0, 1.0, 0.01f));
        this.nodes = new ParticleBox(this.nodesPerCell, space, new GraphCellData());
        this.nodes.addParticleBoxListener(this);
        this.setQuality(this.quality);
        this.sinkTime = new SinkTime();
        this.sourceTime.setSinkTime(this.sinkTime);
    }

    public Point3 getLowPoint() {
        org.miv.pherd.geom.Point3 p = this.nodes.getNTree().getLowestPoint();
        this.lo.set(p.x, p.y, p.z);
        return this.lo;
    }

    public Point3 getHiPoint() {
        org.miv.pherd.geom.Point3 p = this.nodes.getNTree().getHighestPoint();
        this.hi.set(p.x, p.y, p.z);
        return this.hi;
    }

    public double randomXInsideBounds() {
        org.miv.pherd.geom.Point3 c = ((GraphCellData)this.nodes.getNTree().getRootCell().getData()).center;
        return c.x + (this.random.nextDouble() * 2.0 - 1.0);
    }

    public double randomYInsideBounds() {
        org.miv.pherd.geom.Point3 c = ((GraphCellData)this.nodes.getNTree().getRootCell().getData()).center;
        return c.y + (this.random.nextDouble() * 2.0 - 1.0);
    }

    public double randomZInsideBounds() {
        org.miv.pherd.geom.Point3 c = ((GraphCellData)this.nodes.getNTree().getRootCell().getData()).center;
        return c.z + (this.random.nextDouble() * 2.0 - 1.0);
    }

    public Point3 getCenterPoint() {
        return this.center;
    }

    public double getGravityFactor() {
        return this.gravity;
    }

    public void setGravityFactor(double value) {
        this.gravity = value;
    }

    public ParticleBox getSpatialIndex() {
        return this.nodes;
    }

    public long getLastStepTime() {
        return this.lastStepTime;
    }

    public abstract String getLayoutAlgorithmName();

    public int getNodeMovedCount() {
        return this.nodeMoveCount;
    }

    public double getStabilization() {
        if (this.lastElementCount == this.nodes.getParticleCount() + this.edges.size() && this.time > this.energies.getBufferSize()) {
            return this.energies.getStabilization();
        }
        this.lastElementCount = this.nodes.getParticleCount() + this.edges.size();
        return 0.0;
    }

    public double getStabilizationLimit() {
        return this.stabilizationLimit;
    }

    public int getSteps() {
        return this.time;
    }

    public double getQuality() {
        return this.quality;
    }

    public boolean is3D() {
        return this.is3D;
    }

    public double getForce() {
        return this.force;
    }

    public Random getRandom() {
        return this.random;
    }

    public Energies getEnergies() {
        return this.energies;
    }

    public double getBarnesHutTheta() {
        return this.theta;
    }

    public double getViewZone() {
        return this.viewZone;
    }

    public void setSendNodeInfos(boolean on) {
        this.sendNodeInfos = on;
    }

    public void setBarnesHutTheta(double theta) {
        if (theta > 0.0 && theta < 1.0) {
            this.theta = theta;
        }
    }

    public void setForce(double value) {
        this.force = value;
    }

    public void setStabilizationLimit(double value) {
        this.stabilizationLimit = value;
    }

    public void setQuality(double qualityLevel) {
        if (qualityLevel > 1.0) {
            qualityLevel = 1.0;
        } else if (qualityLevel < 0.0) {
            qualityLevel = 0.0;
        }
        this.quality = qualityLevel;
    }

    public void clear() {
        this.energies.clearEnergies();
        this.nodes.removeAllParticles();
        this.edges.clear();
        this.nodeMoveCount = 0;
        this.lastStepTime = 0L;
    }

    public void compute() {
        this.computeArea();
        this.maxMoveLength = Double.MIN_VALUE;
        long t1 = System.currentTimeMillis();
        this.nodeMoveCount = 0;
        this.avgLength = 0.0;
        this.nodes.step();
        if (this.nodeMoveCount > 0) {
            this.avgLength /= (double)this.nodeMoveCount;
        }
        this.getLowPoint();
        this.getHiPoint();
        this.center.set(this.lo.x + (this.hi.x - this.lo.x) / 2.0, this.lo.y + (this.hi.y - this.lo.y) / 2.0, this.lo.z + (this.hi.z - this.lo.z) / 2.0);
        this.energies.storeEnergy();
        this.printStats();
        ++this.time;
        this.lastStepTime = System.currentTimeMillis() - t1;
    }

    protected void printStats() {
        if (this.outputStats) {
            if (this.statsOut == null) {
                try {
                    this.statsOut = new PrintStream("springBox.dat");
                    this.statsOut.printf("# stabilization nodeMoveCount energy energyDiff maxMoveLength avgLength area%n", new Object[0]);
                    this.statsOut.flush();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (this.statsOut != null) {
                double energyDiff = this.energies.getEnergy() - this.energies.getPreviousEnergyValue(30);
                this.statsOut.printf(Locale.US, "%f %d %f %f %f %f%n", this.getStabilization(), this.nodeMoveCount, this.energies.getEnergy(), energyDiff, this.maxMoveLength, this.avgLength, this.area);
                this.statsOut.flush();
            }
        }
    }

    protected void computeArea() {
        this.area = this.getHiPoint().distance(this.getLowPoint());
    }

    public void shake() {
        this.energies.clearEnergies();
    }

    protected NodeParticle addNode(String sourceId, String id) {
        NodeParticle np = this.newNodeParticle(id);
        this.nodes.addParticle(np);
        return np;
    }

    public void moveNode(String id, double x, double y, double z) {
        NodeParticle node = (NodeParticle)this.nodes.getParticle(id);
        if (node != null) {
            node.moveTo(x, y, z);
            this.energies.clearEnergies();
        }
    }

    public void freezeNode(String id, boolean on) {
        NodeParticle node = (NodeParticle)this.nodes.getParticle(id);
        if (node != null) {
            node.frozen = on;
        }
    }

    protected void setNodeWeight(String id, double weight) {
        NodeParticle node = (NodeParticle)this.nodes.getParticle(id);
        if (node != null) {
            node.setWeight(weight);
        }
    }

    protected void removeNode(String sourceId, String id) {
        NodeParticle node = (NodeParticle)this.nodes.removeParticle(id);
        if (node != null) {
            node.removeNeighborEdges();
        } else {
            System.err.printf("layout %s: cannot remove non existing node %s%n", this.getLayoutAlgorithmName(), id);
        }
    }

    protected void addEdge(String sourceId, String id, String from, String to, boolean directed) {
        NodeParticle n0 = (NodeParticle)this.nodes.getParticle(from);
        NodeParticle n1 = (NodeParticle)this.nodes.getParticle(to);
        if (n0 != null && n1 != null) {
            EdgeSpring e = new EdgeSpring(id, n0, n1);
            EdgeSpring o = this.edges.put(id, e);
            if (o != null) {
                System.err.printf("layout %s: edge '%s' already exists%n", this.getLayoutAlgorithmName(), id);
            } else {
                n0.registerEdge(e);
                n1.registerEdge(e);
            }
            this.chooseNodePosition(n0, n1);
        } else {
            if (n0 == null) {
                System.err.printf("layout %s: node '%s' does not exist, cannot create edge %s%n", this.getLayoutAlgorithmName(), from, id);
            }
            if (n1 == null) {
                System.err.printf("layout %s: node '%s' does not exist, cannot create edge %s%n", this.getLayoutAlgorithmName(), to, id);
            }
        }
    }

    protected abstract void chooseNodePosition(NodeParticle var1, NodeParticle var2);

    protected void addEdgeBreakPoint(String edgeId, int points) {
        System.err.printf("layout %s: edge break points are not handled yet.%n", this.getLayoutAlgorithmName());
    }

    protected void ignoreEdge(String edgeId, boolean on) {
        EdgeSpring edge = this.edges.get(edgeId);
        if (edge != null) {
            edge.ignored = on;
        }
    }

    protected void setEdgeWeight(String id, double weight) {
        EdgeSpring edge = this.edges.get(id);
        if (edge != null) {
            edge.weight = weight;
        }
    }

    protected void removeEdge(String sourceId, String id) {
        EdgeSpring e = this.edges.remove(id);
        if (e != null) {
            e.node0.unregisterEdge(e);
            e.node1.unregisterEdge(e);
        } else {
            System.err.printf("layout %s: cannot remove non existing edge %s%n", this.getLayoutAlgorithmName(), id);
        }
    }

    public void particleAdded(Object id, double x, double y, double z, Object mark) {
    }

    public void particleAdded(Object id, double x, double y, double z) {
    }

    public void particleMarked(Object id, Object mark) {
    }

    public void particleMoved(Object id, double x, double y, double z) {
        if (this.time % this.sendMoveEventsEvery == 0) {
            Object[] xyz = new Object[]{x, y, z};
            this.sendNodeAttributeChanged(this.sourceId, (String)id, "xyz", xyz, xyz);
        }
    }

    public void particleRemoved(Object id) {
    }

    public void stepFinished(int time) {
    }

    public void particleAttributeChanged(Object id, String attribute, Object newValue, boolean removed) {
    }

    public void edgeAdded(String graphId, long time, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.addEdge(graphId, edgeId, fromNodeId, toNodeId, directed);
            this.sendEdgeAdded(graphId, time, edgeId, fromNodeId, toNodeId, directed);
        }
    }

    public void nodeAdded(String graphId, long time, String nodeId) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            NodeParticle np = this.addNode(graphId, nodeId);
            this.sendNodeAdded(graphId, time, nodeId);
        }
    }

    public void edgeRemoved(String graphId, long time, String edgeId) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.removeEdge(graphId, edgeId);
            this.sendEdgeRemoved(graphId, time, edgeId);
        }
    }

    public void nodeRemoved(String graphId, long time, String nodeId) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.removeNode(graphId, nodeId);
            this.sendNodeRemoved(graphId, time, nodeId);
        }
    }

    public void graphCleared(String graphId, long time) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.clear();
            this.sendGraphCleared(graphId, time);
        }
    }

    public void stepBegins(String graphId, long time, double step) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.sendStepBegins(graphId, time, step);
        }
    }

    public void graphAttributeAdded(String graphId, long time, String attribute, Object value) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.graphAttributeChanged_(graphId, attribute, null, value);
            this.sendGraphAttributeAdded(graphId, time, attribute, value);
        }
    }

    public void graphAttributeChanged(String graphId, long time, String attribute, Object oldValue, Object newValue) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.graphAttributeChanged_(graphId, attribute, oldValue, newValue);
            this.sendGraphAttributeChanged(graphId, time, attribute, oldValue, newValue);
        }
    }

    protected void graphAttributeChanged_(String graphId, String attribute, Object oldValue, Object newValue) {
        if (attribute.equals("layout.force")) {
            if (newValue instanceof Number) {
                this.setForce(((Number)newValue).doubleValue());
            }
            this.energies.clearEnergies();
        } else if (attribute.equals("layout.quality")) {
            if (newValue instanceof Number) {
                int q = ((Number)newValue).intValue();
                q = q > 4 ? 4 : q;
                q = q < 0 ? 0 : q;
                this.setQuality(q);
                System.err.printf("layout.%s.quality: %d%n", this.getLayoutAlgorithmName(), q);
            }
            this.energies.clearEnergies();
        } else if (attribute.equals("layout.gravity")) {
            if (newValue instanceof Number) {
                double value = ((Number)newValue).doubleValue();
                this.setGravityFactor(value);
                System.err.printf("layout.%s.gravity: %f%n", this.getLayoutAlgorithmName(), value);
            }
        } else if (attribute.equals("layout.exact-zone")) {
            if (newValue instanceof Number) {
                double factor = ((Number)newValue).doubleValue();
                factor = factor > 1.0 ? 1.0 : factor;
                this.viewZone = factor = factor < 0.0 ? 0.0 : factor;
                System.err.printf("layout.%s.exact-zone: %f of [0..1]%n", this.getLayoutAlgorithmName(), this.viewZone);
                this.energies.clearEnergies();
            }
        } else if (attribute.equals("layout.output-stats")) {
            this.outputStats = newValue != null;
            System.err.printf("layout.%s.output-stats: %b%n", this.getLayoutAlgorithmName(), this.outputStats);
        } else if (attribute.equals("layout.stabilization-limit") && newValue instanceof Number) {
            this.stabilizationLimit = ((Number)newValue).doubleValue();
            if (this.stabilizationLimit > 1.0) {
                this.stabilizationLimit = 1.0;
            } else if (this.stabilizationLimit < 0.0) {
                this.stabilizationLimit = 0.0;
            }
            this.energies.clearEnergies();
        }
    }

    public void graphAttributeRemoved(String graphId, long time, String attribute) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.sendGraphAttributeRemoved(graphId, time, attribute);
        }
    }

    public void nodeAttributeAdded(String graphId, long time, String nodeId, String attribute, Object value) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.nodeAttributeChanged_(graphId, nodeId, attribute, null, value);
            this.sendNodeAttributeAdded(graphId, time, nodeId, attribute, value);
        }
    }

    public void nodeAttributeChanged(String graphId, long time, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.nodeAttributeChanged_(graphId, nodeId, attribute, oldValue, newValue);
            this.sendNodeAttributeChanged(graphId, time, nodeId, attribute, oldValue, newValue);
        }
    }

    protected void nodeAttributeChanged_(String graphId, String nodeId, String attribute, Object oldValue, Object newValue) {
        NodeParticle node;
        if (attribute.equals("layout.weight")) {
            if (newValue instanceof Number) {
                this.setNodeWeight(nodeId, ((Number)newValue).doubleValue());
            } else if (newValue == null) {
                this.setNodeWeight(nodeId, 1.0);
            }
            this.energies.clearEnergies();
        } else if (attribute.equals("layout.frozen")) {
            this.freezeNode(nodeId, newValue != null);
        } else if (attribute.equals("xyz") || attribute.equals("xy")) {
            double[] xyz = new double[3];
            GraphPosLengthUtils.positionFromObject(newValue, xyz);
            this.moveNode(nodeId, xyz[0], xyz[1], xyz[2]);
        } else if (attribute.equals("x") && newValue instanceof Number) {
            NodeParticle node2 = (NodeParticle)this.nodes.getParticle(nodeId);
            if (node2 != null) {
                this.moveNode(nodeId, ((Number)newValue).doubleValue(), node2.getPosition().y, node2.getPosition().z);
            }
        } else if (attribute.equals("y") && newValue instanceof Number && (node = (NodeParticle)this.nodes.getParticle(nodeId)) != null) {
            this.moveNode(nodeId, node.getPosition().x, ((Number)newValue).doubleValue(), node.getPosition().z);
        }
    }

    public void nodeAttributeRemoved(String graphId, long time, String nodeId, String attribute) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.nodeAttributeChanged_(graphId, nodeId, attribute, null, null);
            this.sendNodeAttributeRemoved(graphId, time, nodeId, attribute);
        }
    }

    public void edgeAttributeAdded(String graphId, long time, String edgeId, String attribute, Object value) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.edgeAttributeChanged_(graphId, edgeId, attribute, null, value);
            this.sendEdgeAttributeAdded(graphId, time, edgeId, attribute, value);
        }
    }

    public void edgeAttributeChanged(String graphId, long time, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.edgeAttributeChanged_(graphId, edgeId, attribute, oldValue, newValue);
            this.sendEdgeAttributeChanged(graphId, time, edgeId, attribute, oldValue, newValue);
        }
    }

    protected void edgeAttributeChanged_(String graphId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (attribute.equals("layout.weight")) {
            if (newValue instanceof Number) {
                this.setEdgeWeight(edgeId, ((Number)newValue).doubleValue());
            } else if (newValue == null) {
                this.setEdgeWeight(edgeId, 1.0);
            }
            this.energies.clearEnergies();
        } else if (attribute.equals("layout.ignored")) {
            if (newValue instanceof Boolean) {
                this.ignoreEdge(edgeId, (Boolean)newValue);
            }
            this.energies.clearEnergies();
        }
    }

    public void edgeAttributeRemoved(String graphId, long time, String edgeId, String attribute) {
        if (this.sinkTime.isNewEvent(graphId, time)) {
            this.edgeAttributeChanged_(graphId, edgeId, attribute, null, null);
            this.sendEdgeAttributeRemoved(attribute, time, edgeId, attribute);
        }
    }

    public abstract NodeParticle newNodeParticle(String var1);
}

