/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.stylesheet;

public class Selector {
    public Type type;
    public String id;
    public String clazz;
    public String pseudoClass;

    public Selector(Type type) {
        this.type = type;
    }

    public Selector(Type type, String identifier, String clazz) {
        this.type = type;
        this.setId(identifier);
        this.setClass(clazz);
    }

    public Selector(String type) {
        if (type.equals("node")) {
            this.type = Type.NODE;
        } else if (type.equals("edge")) {
            this.type = Type.EDGE;
        } else if (type.equals("graph")) {
            this.type = Type.GRAPH;
        } else if (type.equals("sprite")) {
            this.type = Type.SPRITE;
        } else {
            throw new RuntimeException("invalid matcher type '" + type + "'");
        }
    }

    public Selector(Selector other) {
        this.type = other.type;
        this.setId(other.id);
        this.setClass(other.clazz);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setClass(String clazz) {
        this.clazz = clazz;
    }

    public void setPseudoClass(String pseudoClass) {
        this.pseudoClass = pseudoClass;
    }

    public Type getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public String getClazz() {
        return this.clazz;
    }

    public String getPseudoClass() {
        return this.pseudoClass;
    }

    public String toString() {
        return String.format("%s%s%s%s", this.type.toString(), this.id != null ? String.format("#%s", this.id) : "", this.clazz != null ? String.format(".%s", this.clazz) : "", this.pseudoClass != null ? String.format(":%s", this.pseudoClass) : "");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ANY,
        GRAPH,
        NODE,
        EDGE,
        SPRITE;

    }
}

