/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.stylesheet;

import java.util.HashSet;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.Style;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule {
    public Selector selector;
    public Style style;
    public HashSet<String> groups;

    protected Rule() {
    }

    public Rule(Selector selector) {
        this.selector = selector;
    }

    public Rule(Selector selector, Rule parent) {
        this.selector = selector;
        this.style = new Style(parent);
    }

    public Style getStyle() {
        return this.style;
    }

    public HashSet<String> getGroups() {
        return this.groups;
    }

    public boolean matchId(String identifier) {
        String ident = this.selector.getId();
        if (ident != null) {
            return ident.equals(identifier);
        }
        return false;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void addGroup(String groupId) {
        if (this.groups == null) {
            this.groups = new HashSet();
        }
        this.groups.add(groupId);
    }

    public void removeGroup(String groupId) {
        if (this.groups != null) {
            this.groups.remove(groupId);
        }
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int level) {
        StringBuilder builder = new StringBuilder();
        String prefix = "";
        if (level > 0) {
            for (int i = 0; i < level; ++i) {
                prefix = prefix + "    ";
            }
        }
        builder.append(prefix);
        builder.append(this.selector.toString());
        builder.append(this.style.toString(level + 1));
        return builder.toString();
    }
}

