/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.thread;

import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.graphstream.graph.Graph;
import org.graphstream.stream.AttributeSink;
import org.graphstream.stream.ProxyPipe;
import org.graphstream.stream.Replayable;
import org.graphstream.stream.Sink;
import org.graphstream.stream.Source;
import org.graphstream.stream.SourceBase;

public class ThreadProxyPipe
extends SourceBase
implements ProxyPipe {
    protected String id;
    protected String from = "<in>";
    protected LinkedList<GraphEvents> events = new LinkedList();
    protected LinkedList<Object[]> eventsData = new LinkedList();
    protected ReentrantLock lock = new ReentrantLock();
    protected Condition notEmpty = this.lock.newCondition();
    protected Source input = null;
    protected boolean unregisterWhenPossible = false;

    public ThreadProxyPipe() {
    }

    @Deprecated
    public ThreadProxyPipe(Source input) {
        this(input, null, input instanceof Replayable);
    }

    @Deprecated
    public ThreadProxyPipe(Source input, boolean replay) {
        this(input, null, replay);
    }

    @Deprecated
    public ThreadProxyPipe(Source input, Sink initialListener, boolean replay) {
        this();
        if (initialListener != null) {
            this.addSink(initialListener);
        }
        this.init(input, replay);
    }

    public void init() {
        this.init(null, false);
    }

    public void init(Source source) {
        this.init(source, source instanceof Replayable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Source source, boolean replay) {
        this.lock.lock();
        try {
            if (this.input != null) {
                this.input.removeSink(this);
            }
            this.input = source;
            this.events.clear();
            this.eventsData.clear();
        }
        finally {
            this.lock.unlock();
        }
        if (source != null) {
            if (source instanceof Graph) {
                this.from = ((Graph)source).getId();
            }
            this.input.addSink(this);
            if (replay && source instanceof Replayable) {
                Replayable r = (Replayable)((Object)source);
                Replayable.Controller rc = r.getReplayController();
                rc.addSink(this);
                rc.replay();
            }
        }
    }

    public String toString() {
        String dest = "nil";
        if (this.attrSinks.size() > 0) {
            dest = ((AttributeSink)this.attrSinks.get(0)).toString();
        }
        return String.format("thread-proxy(from %s to %s)", this.from, dest);
    }

    public void unregisterFromSource() {
        this.unregisterWhenPossible = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pump() {
        GraphEvents e = null;
        Object[] data = null;
        do {
            this.lock.lock();
            try {
                e = this.events.poll();
                data = this.eventsData.poll();
            }
            finally {
                this.lock.unlock();
            }
            if (e == null) continue;
            this.processMessage(e, data);
        } while (e != null);
    }

    public void blockingPump() throws InterruptedException {
        this.blockingPump(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void blockingPump(long timeout) throws InterruptedException {
        GraphEvents e;
        this.lock.lock();
        try {
            if (timeout > 0L) {
                while (this.events.size() == 0) {
                    this.notEmpty.await(timeout, TimeUnit.MILLISECONDS);
                }
            } else {
                while (this.events.size() == 0) {
                    this.notEmpty.await();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        do {
            Object[] data;
            this.lock.lock();
            try {
                e = this.events.poll();
                data = this.eventsData.poll();
            }
            finally {
                this.lock.unlock();
            }
            if (e == null) continue;
            this.processMessage(e, data);
        } while (e != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPostRemaining() {
        boolean r = true;
        this.lock.lock();
        try {
            r = this.events.size() > 0;
        }
        finally {
            this.lock.unlock();
        }
        return r;
    }

    protected boolean maybeUnregister() {
        if (this.unregisterWhenPossible) {
            if (this.input != null) {
                this.input.removeSink(this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void post(GraphEvents e, Object ... data) {
        this.lock.lock();
        try {
            this.events.add(e);
            this.eventsData.add(data);
            this.notEmpty.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void edgeAttributeAdded(String graphId, long timeId, String edgeId, String attribute, Object value) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.ADD_EDGE_ATTR, graphId, timeId, edgeId, attribute, value);
    }

    public void edgeAttributeChanged(String graphId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.CHG_EDGE_ATTR, graphId, timeId, edgeId, attribute, oldValue, newValue);
    }

    public void edgeAttributeRemoved(String graphId, long timeId, String edgeId, String attribute) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.DEL_EDGE_ATTR, graphId, timeId, edgeId, attribute);
    }

    public void graphAttributeAdded(String graphId, long timeId, String attribute, Object value) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.ADD_GRAPH_ATTR, graphId, timeId, attribute, value);
    }

    public void graphAttributeChanged(String graphId, long timeId, String attribute, Object oldValue, Object newValue) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.CHG_GRAPH_ATTR, graphId, timeId, attribute, oldValue, newValue);
    }

    public void graphAttributeRemoved(String graphId, long timeId, String attribute) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.DEL_GRAPH_ATTR, graphId, timeId, attribute);
    }

    public void nodeAttributeAdded(String graphId, long timeId, String nodeId, String attribute, Object value) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.ADD_NODE_ATTR, graphId, timeId, nodeId, attribute, value);
    }

    public void nodeAttributeChanged(String graphId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.CHG_NODE_ATTR, graphId, timeId, nodeId, attribute, oldValue, newValue);
    }

    public void nodeAttributeRemoved(String graphId, long timeId, String nodeId, String attribute) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.DEL_NODE_ATTR, graphId, timeId, nodeId, attribute);
    }

    public void edgeAdded(String graphId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.ADD_EDGE, graphId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    public void edgeRemoved(String graphId, long timeId, String edgeId) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.DEL_EDGE, graphId, timeId, edgeId);
    }

    public void graphCleared(String graphId, long timeId) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.CLEARED, graphId, timeId);
    }

    public void nodeAdded(String graphId, long timeId, String nodeId) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.ADD_NODE, graphId, timeId, nodeId);
    }

    public void nodeRemoved(String graphId, long timeId, String nodeId) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.DEL_NODE, graphId, timeId, nodeId);
    }

    public void stepBegins(String graphId, long timeId, double step) {
        if (this.maybeUnregister()) {
            return;
        }
        this.post(GraphEvents.STEP, graphId, timeId, step);
    }

    public void processMessage(GraphEvents e, Object[] data) {
        switch (e) {
            case ADD_NODE: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                this.sendNodeAdded(graphId, timeId, elementId);
                break;
            }
            case DEL_NODE: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                this.sendNodeRemoved(graphId, timeId, elementId);
                break;
            }
            case ADD_EDGE: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                String fromId = (String)data[3];
                String toId = (String)data[4];
                boolean directed = (Boolean)data[5];
                this.sendEdgeAdded(graphId, timeId, elementId, fromId, toId, directed);
                break;
            }
            case DEL_EDGE: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                this.sendEdgeRemoved(graphId, timeId, elementId);
                break;
            }
            case STEP: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                double step = (Double)data[2];
                this.sendStepBegins(graphId, timeId, step);
                break;
            }
            case ADD_GRAPH_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String attribute = (String)data[2];
                Object newValue = data[3];
                this.sendGraphAttributeAdded(graphId, timeId, attribute, newValue);
                break;
            }
            case CHG_GRAPH_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String attribute = (String)data[2];
                Object oldValue = data[3];
                Object newValue = data[4];
                this.sendGraphAttributeChanged(graphId, timeId, attribute, oldValue, newValue);
                break;
            }
            case DEL_GRAPH_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String attribute = (String)data[2];
                this.sendGraphAttributeRemoved(graphId, timeId, attribute);
                break;
            }
            case ADD_EDGE_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                String attribute = (String)data[3];
                Object newValue = data[4];
                this.sendEdgeAttributeAdded(graphId, timeId, elementId, attribute, newValue);
                break;
            }
            case CHG_EDGE_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                String attribute = (String)data[3];
                Object oldValue = data[4];
                Object newValue = data[5];
                this.sendEdgeAttributeChanged(graphId, timeId, elementId, attribute, oldValue, newValue);
                break;
            }
            case DEL_EDGE_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                String attribute = (String)data[3];
                this.sendEdgeAttributeRemoved(graphId, timeId, elementId, attribute);
                break;
            }
            case ADD_NODE_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                String attribute = (String)data[3];
                Object newValue = data[4];
                this.sendNodeAttributeAdded(graphId, timeId, elementId, attribute, newValue);
                break;
            }
            case CHG_NODE_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                String attribute = (String)data[3];
                Object oldValue = data[4];
                Object newValue = data[5];
                this.sendNodeAttributeChanged(graphId, timeId, elementId, attribute, oldValue, newValue);
                break;
            }
            case DEL_NODE_ATTR: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                String elementId = (String)data[2];
                String attribute = (String)data[3];
                this.sendNodeAttributeRemoved(graphId, timeId, elementId, attribute);
                break;
            }
            case CLEARED: {
                String graphId = (String)data[0];
                Long timeId = (Long)data[1];
                this.sendGraphCleared(graphId, timeId);
                break;
            }
            default: {
                System.err.printf("ThreadProxy : Unknown message %s !!%n", new Object[]{e});
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum GraphEvents {
        ADD_NODE,
        DEL_NODE,
        ADD_EDGE,
        DEL_EDGE,
        STEP,
        CLEARED,
        ADD_GRAPH_ATTR,
        CHG_GRAPH_ATTR,
        DEL_GRAPH_ATTR,
        ADD_NODE_ATTR,
        CHG_NODE_ATTR,
        DEL_NODE_ATTR,
        ADD_EDGE_ATTR,
        CHG_EDGE_ATTR,
        DEL_EDGE_ATTR;

    }
}

