/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gml;

import java.io.IOException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyValues
extends HashMap<String, Object> {
    private static final long serialVersionUID = 5920553787913520204L;
    public String key;
    public int line;
    public int column;

    KeyValues() {
    }

    public void print() {
        System.err.printf("%s:%n", this.key);
        for (String k : this.keySet()) {
            System.err.printf("    %s: %s%n", k, this.get(k));
        }
    }

    public String optString(String key) throws IOException {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            o = o.toString();
        }
        if (!(o instanceof String)) {
            throw new IOException(String.format("%d:%d: expecting a string or number value for tag %s, got a list of values", this.line, this.column, key));
        }
        this.remove(key);
        return (String)o;
    }

    protected String reqString(String key) throws IOException {
        Object o = this.get(key);
        if (o == null) {
            throw new IOException(String.format("%d:%d: expecting a tag %s but none found", this.line, this.column, key));
        }
        if (!(o instanceof String)) {
            throw new IOException(String.format("%d:%d: expecting a string or number value for tag %s, got a list of values", this.line, this.column, key));
        }
        this.remove(key);
        return (String)o;
    }

    protected String reqStringOrNumber(String key) throws IOException {
        Object o = this.get(key);
        if (o == null) {
            throw new IOException(String.format("%d:%d: expecting a tag %s but none found", this.line, this.column, key));
        }
        if (!(o instanceof String) && !(o instanceof Number)) {
            throw new IOException(String.format("%d:%d: expecting a string or number value for tag %s, got a list of values", this.line, this.column, key));
        }
        this.remove(key);
        if (o instanceof Number) {
            o = o.toString();
        }
        return (String)o;
    }

    protected double reqNumber(String key) throws IOException {
        Object o = this.get(key);
        double v = 0.0;
        if (o == null) {
            throw new IOException(String.format("%d:%d: expecting a tag %s but none found", this.line, this.column, key));
        }
        if (!(o instanceof String)) {
            throw new IOException(String.format("%d:%d expecting a string or number value for tag %s, got a list of values", this.line, this.column, key));
        }
        try {
            this.remove(key);
            v = Double.parseDouble((String)o);
        }
        catch (NumberFormatException e) {
            throw new IOException(String.format("%d:%d: expecting a number value for tag %s, got a string", this.line, this.column, key));
        }
        return v;
    }

    protected KeyValues optKeyValues(String key) throws IOException {
        Object o = this.get(key);
        if (o == null) {
            return null;
        }
        if (!(o instanceof KeyValues)) {
            throw new IOException(String.format("%d:%d: expecting a list of values for tag %s, got a string or number", this.line, this.column, key));
        }
        this.remove(key);
        return (KeyValues)o;
    }

    protected KeyValues reqKeyValues(String key) throws IOException {
        Object o = this.get(key);
        if (o == null) {
            throw new IOException(String.format("%d:%d: expecting a tag %s but none found", this.line, this.column, key));
        }
        if (!(o instanceof KeyValues)) {
            throw new IOException(String.format("%d:%d: expecting a list of values for tag %s, got a string or number", this.line, this.column, key));
        }
        this.remove(key);
        return (KeyValues)o;
    }

    protected void error(String message) throws IOException {
        throw new IOException(String.format("%d:%d: %s", this.line, this.column, message));
    }
}

