/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import java.io.Writer;
import java.util.LinkedList;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class SmartXMLWriter {
    public final XMLStreamWriter stream;
    boolean smart;
    int depth;
    LinkedList<Integer> childrenCount;

    public SmartXMLWriter(Writer output, boolean smart) throws XMLStreamException, FactoryConfigurationError {
        this.stream = XMLOutputFactory.newFactory().createXMLStreamWriter(output);
        this.stream.writeStartDocument("UTF-8", "1.0");
        this.smart = smart;
        this.depth = 0;
        this.childrenCount = new LinkedList();
        this.childrenCount.add(0);
    }

    public void startElement(String name) throws XMLStreamException {
        if (this.smart) {
            this.stream.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                this.stream.writeCharacters(" ");
            }
        }
        this.childrenCount.set(0, this.childrenCount.get(0) + 1);
        this.childrenCount.addFirst(0);
        this.stream.writeStartElement(name);
        ++this.depth;
    }

    public void endElement() throws XMLStreamException {
        boolean leaf;
        --this.depth;
        boolean bl = leaf = this.childrenCount.pop() == 0;
        if (this.smart && !leaf) {
            this.stream.writeCharacters("\n");
            for (int i = 0; i < this.depth; ++i) {
                this.stream.writeCharacters(" ");
            }
        }
        this.stream.writeEndElement();
    }

    public void leafWithText(String name, String content) throws XMLStreamException {
        this.startElement(name);
        this.stream.writeCharacters(content);
        this.endElement();
    }

    public void flush() {
        try {
            this.stream.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    public void close() throws XMLStreamException {
        this.stream.writeEndDocument();
        this.stream.flush();
        this.stream.close();
    }
}

