/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.GEXFSpell;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFSpells
implements GEXFElement {
    GEXF root;
    LinkedList<GEXFSpell> spells;

    public GEXFSpells(GEXF root) {
        this.root = root;
        this.spells = new LinkedList();
    }

    public void start() {
        double date = this.root.step;
        if (this.spells.size() == 0 || this.spells.getLast().closed) {
            GEXFSpell spell = new GEXFSpell(this.root);
            spell.start = date;
            this.spells.add(spell);
        }
    }

    public void end() {
        double date = this.root.step;
        if (this.spells.size() > 0 && !this.spells.getLast().closed) {
            GEXFSpell spell = this.spells.getLast();
            spell.end = date;
            spell.closed = true;
        }
    }

    public void export(SmartXMLWriter stream) throws XMLStreamException {
        if (this.spells.size() == 0) {
            return;
        }
        stream.startElement("spells");
        for (int i = 0; i < this.spells.size(); ++i) {
            this.spells.get(i).export(stream);
        }
        stream.endElement();
    }
}

