/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file.gexf;

import javax.xml.stream.XMLStreamException;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFAttValues;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.GEXFSpells;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class GEXFEdge
implements GEXFElement {
    GEXF root;
    String id;
    String label;
    String source;
    String target;
    boolean directed;
    double weight = Double.NaN;
    GEXFAttValues attvalues;
    GEXFSpells spells;

    public GEXFEdge(GEXF root, String id, String source, String target, boolean directed) {
        this.root = root;
        this.id = id;
        this.label = id;
        this.source = source;
        this.target = target;
        this.directed = directed;
        this.spells = new GEXFSpells(root);
        this.attvalues = new GEXFAttValues(root);
    }

    public void export(SmartXMLWriter stream) throws XMLStreamException {
        stream.startElement("edge");
        stream.stream.writeAttribute("id", this.id);
        stream.stream.writeAttribute("label", this.label);
        stream.stream.writeAttribute("source", this.source);
        stream.stream.writeAttribute("target", this.target);
        stream.stream.writeAttribute("type", this.directed ? "directed" : "undirected");
        if (!Double.isNaN(this.weight)) {
            stream.stream.writeAttribute("weight", Double.toString(this.weight));
        }
        if (this.root.isExtensionEnable(GEXFElement.Extension.DYNAMICS)) {
            this.spells.export(stream);
        }
        this.attvalues.export(stream);
        stream.endElement();
    }
}

