/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import org.graphstream.stream.file.FileSourceBase;

public class FileSourceLGL
extends FileSourceBase {
    protected int edgeid = 0;
    protected HashSet<String> nodes;
    protected String source;
    protected String graphName = "LGL_";

    public FileSourceLGL() {
        this(false);
    }

    public FileSourceLGL(boolean declareNodes) {
        this.nodes = declareNodes ? new HashSet() : null;
    }

    protected void continueParsingInInclude() throws IOException {
    }

    public boolean nextEvents() throws IOException {
        String id1 = this.getWordOrSymbolOrNumberOrStringOrEolOrEof();
        if (!id1.equals("EOL")) {
            if (id1.equals("EOF")) {
                return false;
            }
            if (id1.equals("#")) {
                String src = this.getWordOrNumberOrStringOrEolOrEof();
                this.source = !src.equals("EOL") && !src.equals("EOF") ? src : null;
            } else if (this.source != null) {
                String weight = this.getWordOrNumberOrStringOrEolOrEof();
                double w = 0.0;
                if (weight.equals("EOL") || weight.equals("EOF")) {
                    weight = null;
                    this.pushBack();
                } else {
                    try {
                        w = Double.parseDouble(weight);
                    }
                    catch (Exception e) {
                        throw new IOException(String.format("cannot transform weight %s into a number", weight));
                    }
                }
                String edgeId = Integer.toString(this.edgeid++);
                this.sendEdgeAdded(this.graphName, edgeId, this.source, id1, false);
                if (weight != null) {
                    this.sendEdgeAttributeAdded(this.graphName, edgeId, "weight", w);
                }
            }
        }
        return true;
    }

    protected void declareNode(String id) {
        if (this.nodes != null && !this.nodes.contains(id)) {
            this.sendNodeAdded(this.graphName, id);
            this.nodes.add(id);
        }
    }

    public void begin(String filename) throws IOException {
        super.begin(filename);
        this.init();
    }

    public void begin(URL url) throws IOException {
        super.begin(url);
        this.init();
    }

    public void begin(InputStream stream) throws IOException {
        super.begin(stream);
        this.init();
    }

    public void begin(Reader reader) throws IOException {
        super.begin(reader);
        this.init();
    }

    protected void init() throws IOException {
        this.st.eolIsSignificant(true);
        this.st.commentChar(37);
        this.graphName = String.format("%s_%d", this.graphName, System.currentTimeMillis() + (long)Math.random() * 10L);
    }

    public boolean nextStep() throws IOException {
        return this.nextEvents();
    }

    public void end() throws IOException {
        super.end();
    }
}

