/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.awt.Color;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Node;
import org.graphstream.stream.GraphReplay;
import org.graphstream.stream.file.FileSinkBase;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.GraphicEdge;
import org.graphstream.ui.graphicGraph.GraphicGraph;
import org.graphstream.ui.graphicGraph.GraphicNode;
import org.graphstream.ui.graphicGraph.StyleGroup;
import org.graphstream.ui.graphicGraph.StyleGroupSet;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;

public class FileSinkTikZ
extends FileSinkBase {
    public static final String XYZ_ATTR = "xyz";
    public static final String WIDTH_ATTR = "ui.tikz.width";
    public static final String HEIGHT_ATTR = "ui.tikz.height";
    public static final double DEFAULT_WIDTH = 10.0;
    public static final double DEFAULT_HEIGHT = 10.0;
    public static final double DISPLAY_MIN_SIZE_IN_MM = 2.0;
    public static final double DISPLAY_MAX_SIZE_IN_MM = 10.0;
    protected PrintWriter out;
    protected HashMap<String, String> colors = new HashMap();
    protected HashMap<String, String> classes = new HashMap();
    protected HashMap<String, String> classNames = new HashMap();
    protected int classIndex = 0;
    protected int colorIndex = 0;
    protected double width = Double.NaN;
    protected double height = Double.NaN;
    protected boolean layout = false;
    protected GraphicGraph buffer;
    protected String css = null;
    protected double minSize = 0.0;
    protected double maxSize = 0.0;
    protected double displayMinSize = 2.0;
    protected double displayMaxSize = 10.0;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private PointsWrapper points;
    private Locale l = Locale.ROOT;

    protected static String formatId(String id) {
        return "node" + id.replaceAll("\\W", "_");
    }

    public FileSinkTikZ() {
        this.buffer = new GraphicGraph("tikz-buffer");
    }

    public double getWidth() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    public void setDisplaySize(double min, double max) {
        this.displayMinSize = min;
        this.displayMaxSize = max;
    }

    public void setCSS(String css) {
        this.css = css;
    }

    public void setLayout(boolean layout) {
        this.layout = layout;
    }

    protected double getNodeX(Node n) {
        if (n.hasAttribute(XYZ_ATTR)) {
            return ((Number)n.getArray(XYZ_ATTR)[0]).doubleValue();
        }
        if (n.hasAttribute("x")) {
            return n.getNumber("x");
        }
        return Double.NaN;
    }

    protected double getNodeY(Node n) {
        if (n.hasAttribute(XYZ_ATTR)) {
            return ((Number)n.getArray(XYZ_ATTR)[1]).doubleValue();
        }
        if (n.hasAttribute("y")) {
            return n.getNumber("y");
        }
        return Double.NaN;
    }

    protected String getNodeStyle(Node n) {
        String style = "tikzgsnode";
        if (n instanceof GraphicNode) {
            GraphicNode gn = (GraphicNode)n;
            style = this.classNames.get(gn.style.getId());
            if (gn.style.getFillMode() == StyleConstants.FillMode.DYN_PLAIN) {
                int s;
                double uicolor = gn.getNumber("ui.color");
                if (Double.isNaN(uicolor)) {
                    uicolor = 0.0;
                }
                int c = gn.style.getFillColorCount();
                double d = 1.0 / (double)(c - 1);
                for (s = 1; (double)s * d < uicolor && s < c; ++s) {
                }
                uicolor -= (double)(s - 1) * d;
                style = style + String.format(Locale.ROOT, ", fill=%s!%d!%s", this.checkColor(gn.style.getFillColor(0)), (int)((uicolor *= (double)c) * 100.0), this.checkColor(gn.style.getFillColor(1)));
            }
            if (gn.style.getSizeMode() == StyleConstants.SizeMode.DYN_SIZE) {
                double uisize = gn.getNumber("ui.size");
                if (Double.isNaN(uisize)) {
                    uisize = this.minSize;
                }
                uisize = (uisize - this.minSize) / (this.maxSize - this.minSize);
                uisize = uisize * (this.displayMaxSize - this.displayMinSize) + this.displayMinSize;
                style = style + String.format(Locale.ROOT, ", minimum size=%fmm", uisize);
            }
        }
        return style;
    }

    protected String getEdgeStyle(Edge e) {
        String style = "tikzgsnode";
        if (e instanceof GraphicEdge) {
            GraphicEdge ge = (GraphicEdge)e;
            style = this.classNames.get(ge.style.getId());
            if (ge.style.getFillMode() == StyleConstants.FillMode.DYN_PLAIN) {
                int s;
                double uicolor = ge.getNumber("ui.color");
                if (Double.isNaN(uicolor)) {
                    uicolor = 0.0;
                }
                int c = ge.style.getFillColorCount();
                double d = 1.0 / (double)(c - 1);
                for (s = 1; (double)s * d < uicolor && s < c; ++s) {
                }
                uicolor -= (double)(s - 1) * d;
                style = style + String.format(Locale.ROOT, ", draw=%s!%d!%s", this.checkColor(ge.style.getFillColor(s - 1)), (int)((uicolor *= (double)c) * 100.0), this.checkColor(ge.style.getFillColor(s)));
            }
            if (ge.style.getSizeMode() == StyleConstants.SizeMode.DYN_SIZE) {
                double uisize = ge.getNumber("ui.size");
                if (Double.isNaN(uisize) || uisize < 0.01) {
                    uisize = 1.0;
                }
                style = style + String.format(Locale.ROOT, ", line width=%fpt", uisize);
            }
        }
        return style;
    }

    protected String checkColor(Color c) {
        String rgb = String.format(Locale.ROOT, "%.3f,%.3f,%.3f", Float.valueOf((float)c.getRed() / 255.0f), Float.valueOf((float)c.getGreen() / 255.0f), Float.valueOf((float)c.getBlue() / 255.0f));
        if (this.colors.containsKey(rgb)) {
            return this.colors.get(rgb);
        }
        String key = String.format("tikzC%02d", this.colorIndex++);
        this.colors.put(rgb, key);
        return key;
    }

    protected String getTikzStyle(StyleGroup group) {
        StringBuilder buffer = new StringBuilder();
        LinkedList<String> style = new LinkedList<String>();
        for (int i = 0; i < group.getFillColorCount(); ++i) {
            this.checkColor(group.getFillColor(i));
        }
        block0 : switch (group.getType()) {
            case NODE: {
                if (group.getFillMode() != StyleConstants.FillMode.DYN_PLAIN) {
                    String fill = this.checkColor(group.getFillColor(0));
                    style.add("fill=" + fill);
                }
                if (group.getFillColor(0).getAlpha() < 255) {
                    style.add(String.format(Locale.ROOT, "fill opacity=%.2f", Float.valueOf((float)group.getFillColor(0).getAlpha() / 255.0f)));
                }
                switch (group.getStrokeMode()) {
                    case DOTS: 
                    case DASHES: 
                    case PLAIN: {
                        String stroke = this.checkColor(group.getStrokeColor(0));
                        style.add("draw=" + stroke);
                        style.add("line width=" + String.format(Locale.ROOT, "%.1fpt", group.getStrokeWidth().value));
                        if (group.getStrokeColor(0).getAlpha() >= 255) break;
                        style.add(String.format(Locale.ROOT, "draw opacity=%.2f", Float.valueOf((float)group.getStrokeColor(0).getAlpha() / 255.0f)));
                        break;
                    }
                    default: {
                        System.err.printf("unhandled stroke mode : %s%n", new Object[]{group.getStrokeMode()});
                    }
                }
                switch (group.getShape()) {
                    case CIRCLE: {
                        style.add("circle");
                        break;
                    }
                    case ROUNDED_BOX: {
                        style.add("rounded corners=2pt");
                    }
                    case BOX: {
                        style.add("rectangle");
                        break;
                    }
                    case TRIANGLE: {
                        style.add("isosceles triangle");
                        break;
                    }
                    case DIAMOND: {
                        style.add("diamond");
                        break;
                    }
                    default: {
                        System.err.printf("unhandled shape : %s%n", new Object[]{group.getShape()});
                    }
                }
                String text = this.checkColor(group.getTextColor(0));
                style.add("text=" + text);
                switch (group.getSize().units) {
                    case GU: {
                        style.add("minimum size=" + String.format(Locale.ROOT, "%.1fcm", group.getSize().values.get(0)));
                        break;
                    }
                    case PX: {
                        style.add("minimum size=" + String.format(Locale.ROOT, "%.1fpt", group.getSize().values.get(0)));
                        break;
                    }
                    default: {
                        System.err.printf("%% [warning] units %s are not compatible with TikZ.%n", new Object[]{group.getSize().units});
                    }
                }
                style.add("inner sep=0pt");
                break;
            }
            case EDGE: {
                if (group.getFillMode() != StyleConstants.FillMode.DYN_PLAIN) {
                    String fill = this.checkColor(group.getFillColor(0));
                    style.add("draw=" + fill);
                }
                if (group.getFillColor(0).getAlpha() < 255) {
                    style.add(String.format(Locale.ROOT, "draw opacity=%.2f", Float.valueOf((float)group.getFillColor(0).getAlpha() / 255.0f)));
                }
                switch (group.getSize().units) {
                    case GU: 
                    case PX: {
                        style.add("line width=" + String.format(Locale.ROOT, "%.1fpt", group.getSize().values.get(0)));
                        break block0;
                    }
                }
                System.err.printf("%% [warning] units %s are not compatible with TikZ.%n", new Object[]{group.getSize().units});
                break;
            }
            default: {
                System.err.printf("unhandled group type : %s%n", new Object[]{group.getType()});
            }
        }
        for (int i = 0; i < style.size(); ++i) {
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append((String)style.get(i));
        }
        return buffer.toString();
    }

    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.colors.clear();
        this.classes.clear();
        this.classNames.clear();
        this.buffer.clear();
    }

    protected void outputEndOfFile() throws IOException {
        if (Double.isNaN(this.width)) {
            this.width = this.buffer.hasNumber(WIDTH_ATTR) ? this.buffer.getNumber(WIDTH_ATTR) : 10.0;
        }
        if (Double.isNaN(this.height)) {
            this.height = this.buffer.hasNumber(HEIGHT_ATTR) ? this.buffer.getNumber(HEIGHT_ATTR) : 10.0;
        }
        this.checkLayout();
        if (this.css != null) {
            this.buffer.addAttribute("ui.stylesheet", this.css);
        }
        this.points = new PointsWrapper();
        this.out.printf("%%%n%% Do not forget \\usepackage{tikz} in header.%n%%%n", new Object[0]);
        this.out.printf("\\begin{tikzpicture}", new Object[0]);
        this.checkAndOutputStyle();
        this.checkXYandSize();
        for (Node node : this.buffer.getEachNode()) {
            double x = this.getNodeX(node);
            double y = this.getNodeY(node);
            if (Double.isNaN(x) || Double.isNaN(y)) {
                x = Math.random() * this.width;
                y = Math.random() * this.height;
            } else {
                x = this.width * (x - this.xmin) / (this.xmax - this.xmin);
                y = this.height * (y - this.ymin) / (this.ymax - this.ymin);
            }
            this.out.printf(this.l, "\t\\node[inner sep=0pt] (%s) at (%f,%f) {};%n", FileSinkTikZ.formatId(node.getId()), x, y);
        }
        StyleGroupSet sgs = this.buffer.getStyleGroups();
        for (HashSet<StyleGroup> groups : sgs.zIndex()) {
            block6: for (StyleGroup group : groups) {
                switch (group.getType()) {
                    case NODE: {
                        for (Element element : group.elements()) {
                            this.outputNode((Node)element);
                        }
                        continue block6;
                    }
                    case EDGE: {
                        for (Element element : group.elements()) {
                            this.outputEdge((Edge)element);
                        }
                        continue block6;
                    }
                }
            }
        }
        this.out.printf("\\end{tikzpicture}%n", new Object[0]);
    }

    private void checkLayout() {
        if (!this.layout) {
            return;
        }
        SpringBox sbox = new SpringBox();
        GraphReplay replay = new GraphReplay("replay");
        replay.addSink(sbox);
        sbox.addAttributeSink(this.buffer);
        replay.replay(this.buffer);
        do {
            sbox.compute();
        } while (sbox.getStabilization() < 0.9);
        this.buffer.removeSink(sbox);
        sbox.removeAttributeSink(this.buffer);
    }

    private void checkXYandSize() {
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.ymax = Double.MIN_VALUE;
        this.xmax = Double.MIN_VALUE;
        for (Node node : this.buffer.getEachNode()) {
            double x = this.getNodeX(node);
            double y = this.getNodeY(node);
            if (!Double.isNaN(x) && !Double.isNaN(y)) {
                this.xmin = Math.min(this.xmin, x);
                this.xmax = Math.max(this.xmax, x);
                this.ymin = Math.min(this.ymin, y);
                this.ymax = Math.max(this.ymax, y);
            } else {
                System.err.printf("%% [warning] missing node (x,y).%n", new Object[0]);
            }
            if (!node.hasNumber("ui.size")) continue;
            this.minSize = Math.min(this.minSize, node.getNumber("ui.size"));
            this.maxSize = Math.max(this.maxSize, node.getNumber("ui.size"));
        }
        if (this.minSize == this.maxSize) {
            this.maxSize += 1.0;
        }
        for (Edge edge : this.buffer.getEachEdge()) {
            this.points.setElement(edge);
            if (!this.points.check()) continue;
            for (int i = 0; i < this.points.getPointsCount(); ++i) {
                double x = this.points.getX(i);
                double y = this.points.getY(i);
                this.xmin = Math.min(this.xmin, x);
                this.xmax = Math.max(this.xmax, x);
                this.ymin = Math.min(this.ymin, y);
                this.ymax = Math.max(this.ymax, y);
            }
        }
    }

    private void checkAndOutputStyle() {
        String nodeStyle = "circle,draw=black,fill=black";
        String edgeStyle = "draw=black";
        StyleGroupSet sgs = this.buffer.getStyleGroups();
        for (StyleGroup styleGroup : sgs.groups()) {
            String key = String.format("class%02d", this.classIndex++);
            this.classNames.put(styleGroup.getId(), key);
            this.classes.put(key, this.getTikzStyle(styleGroup));
        }
        this.out.printf("[%n", new Object[0]);
        for (String string : this.classes.keySet()) {
            this.out.printf(this.l, "\t%s/.style={%s},%n", string, this.classes.get(string));
        }
        this.out.printf(this.l, "\ttikzgsnode/.style={%s},%n", nodeStyle);
        this.out.printf(this.l, "\ttikzgsedge/.style={%s}%n", edgeStyle);
        this.out.printf("]%n", new Object[0]);
        for (String string : this.colors.keySet()) {
            this.out.printf(this.l, "\t\\definecolor{%s}{rgb}{%s}%n", this.colors.get(string), string);
        }
    }

    private void outputNode(Node n) {
        String style = this.getNodeStyle(n);
        String label = n.hasAttribute("label") ? (String)n.getLabel("label") : "";
        this.out.printf(this.l, "\t\\node[%s] at (%s) {%s};%n", style, FileSinkTikZ.formatId(n.getId()), label);
    }

    private void outputEdge(Edge e) {
        String style = this.getEdgeStyle(e);
        String uiPoints = "";
        this.points.setElement(e);
        if (this.points.check()) {
            for (int i = 0; i < this.points.getPointsCount(); ++i) {
                double x = this.points.getX(i);
                double y = this.points.getY(i);
                x = this.width * (x - this.xmin) / (this.xmax - this.xmin);
                y = this.height * (y - this.ymin) / (this.ymax - this.ymin);
                uiPoints = String.format(this.l, "%s-- (%.3f,%.3f) ", uiPoints, x, y);
            }
        }
        this.out.printf(this.l, "\t\\draw[%s] (%s) %s%s (%s);%n", style, FileSinkTikZ.formatId(e.getSourceNode().getId()), uiPoints, e.isDirected() ? "->" : "--", FileSinkTikZ.formatId(e.getTargetNode().getId()));
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.buffer.graphAttributeAdded(sourceId, timeId, attribute, value);
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.buffer.graphAttributeChanged(sourceId, timeId, attribute, oldValue, newValue);
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.buffer.graphAttributeRemoved(sourceId, timeId, attribute);
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.buffer.nodeAttributeAdded(sourceId, timeId, nodeId, attribute, value);
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        this.buffer.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, oldValue, newValue);
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.buffer.nodeAttributeRemoved(sourceId, timeId, nodeId, attribute);
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.buffer.edgeAttributeAdded(sourceId, timeId, edgeId, attribute, value);
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        this.buffer.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, oldValue, newValue);
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.buffer.edgeAttributeRemoved(sourceId, timeId, edgeId, attribute);
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.buffer.nodeAdded(sourceId, timeId, nodeId);
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.buffer.nodeRemoved(sourceId, timeId, nodeId);
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.buffer.edgeAdded(sourceId, timeId, edgeId, fromNodeId, toNodeId, directed);
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.buffer.edgeRemoved(sourceId, timeId, edgeId);
    }

    public void graphCleared(String sourceId, long timeId) {
        this.buffer.graphCleared(sourceId, timeId);
    }

    public void stepBegins(String sourceId, long timeId, double step) {
        this.buffer.stepBegins(sourceId, timeId, step);
    }

    protected class PointsWrapper {
        Object[] points;

        PointsWrapper() {
        }

        public void setElement(Element e) {
            this.points = e.hasArray("ui.points") ? e.getArray("ui.points") : null;
        }

        public boolean check() {
            if (this.points == null) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i] instanceof Point3 || this.points[i].getClass().isArray()) continue;
                return false;
            }
            return true;
        }

        public int getPointsCount() {
            return this.points == null ? 0 : this.points.length;
        }

        public double getX(int i) {
            if (this.points == null || i >= this.points.length) {
                return Double.NaN;
            }
            Object p = this.points[i];
            if (p instanceof Point3) {
                return ((Point3)p).x;
            }
            Object x = Array.get(p, 0);
            if (x instanceof Number) {
                return ((Number)x).doubleValue();
            }
            return Array.getDouble(p, 0);
        }

        public double getY(int i) {
            if (i >= this.points.length) {
                return Double.NaN;
            }
            Object p = this.points[i];
            if (p instanceof Point3) {
                return ((Point3)p).y;
            }
            Object y = Array.get(p, 0);
            if (y instanceof Number) {
                return ((Number)y).doubleValue();
            }
            return Array.getDouble(p, 1);
        }
    }
}

