/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.regex.Pattern;
import org.graphstream.stream.file.FileSinkBase;

public class FileSinkGML
extends FileSinkBase {
    protected PrintWriter out;
    protected String nodeToFinish = null;
    protected String edgeToFinish = null;
    Pattern forbiddenKeyChars = Pattern.compile(".*[^a-zA-Z0-9-_.].*");

    protected void outputHeader() throws IOException {
        this.out = (PrintWriter)this.output;
        this.out.printf("graph [%n", new Object[0]);
    }

    protected void outputEndOfFile() throws IOException {
        this.ensureToFinish();
        this.out.printf("]%n", new Object[0]);
    }

    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.ensureToFinish();
        String val = this.valueToString(value);
        attribute = this.keyToString(attribute);
        if (val != null) {
            this.out.printf("\t%s %s%n", attribute, val);
        }
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.ensureToFinish();
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.ensureToFinish();
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        if (this.nodeToFinish != null && this.nodeToFinish.equals(nodeId)) {
            String val = this.valueToString(value);
            attribute = this.keyToString(attribute);
            if (val != null) {
                this.out.printf("\t\t%s %s%n", attribute, val);
            }
        } else {
            this.ensureToFinish();
        }
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (this.edgeToFinish != null) {
            this.ensureToFinish();
        }
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        if (this.edgeToFinish != null) {
            this.ensureToFinish();
        }
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        if (this.edgeToFinish != null && this.edgeToFinish.equals(edgeId)) {
            String val = this.valueToString(value);
            attribute = this.keyToString(attribute);
            if (val != null) {
                this.out.printf("\t\t%s %s%n", attribute, val);
            }
        } else {
            this.ensureToFinish();
        }
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (this.nodeToFinish != null) {
            this.ensureToFinish();
        }
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        if (this.nodeToFinish != null) {
            this.ensureToFinish();
        }
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.ensureToFinish();
        this.out.printf("\tnode [%n", new Object[0]);
        this.out.printf("\t\tid \"%s\"%n", nodeId);
        this.nodeToFinish = nodeId;
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.ensureToFinish();
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.ensureToFinish();
        this.out.printf("\tedge [%n", new Object[0]);
        this.out.printf("\t\tid \"%s\"%n", edgeId);
        this.out.printf("\t\tsource \"%s\"%n", fromNodeId);
        this.out.printf("\t\ttarget \"%s\"%n", toNodeId);
        this.edgeToFinish = edgeId;
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.ensureToFinish();
    }

    public void graphCleared(String sourceId, long timeId) {
    }

    public void stepBegins(String sourceId, long timeId, double step) {
    }

    protected String keyToString(String key) {
        if (this.forbiddenKeyChars.matcher(key).matches()) {
            return "\"" + key.replace("\"", "\\\"") + "\"";
        }
        return key;
    }

    protected String valueToString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            double val = ((Number)value).doubleValue();
            if (val - (double)((int)val) == 0.0) {
                return String.format(Locale.US, "%d", (int)val);
            }
            return String.format(Locale.US, "%f", val);
        }
        return String.format("\"%s\"", value.toString().replaceAll("\n|\r|\"", " "));
    }

    protected void ensureToFinish() {
        assert (this.nodeToFinish != null && this.edgeToFinish == null || this.nodeToFinish == null && this.edgeToFinish != null || this.nodeToFinish == null && this.edgeToFinish == null);
        if (this.nodeToFinish != null || this.edgeToFinish != null) {
            this.out.printf("\t]%n", new Object[0]);
            this.nodeToFinish = null;
            this.edgeToFinish = null;
        }
    }
}

