/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import org.graphstream.graph.Graph;
import org.graphstream.stream.GraphReplay;
import org.graphstream.stream.PipeBase;
import org.graphstream.stream.file.FileSink;
import org.graphstream.stream.file.gexf.GEXF;
import org.graphstream.stream.file.gexf.GEXFElement;
import org.graphstream.stream.file.gexf.SmartXMLWriter;

public class FileSinkGEXF2
extends PipeBase
implements FileSink {
    Context currentContext;

    Context createContext(String fileName) throws IOException {
        FileWriter w = new FileWriter(fileName);
        Context ctx = this.createContext(w);
        ctx.closeStreamAtEnd = true;
        return ctx;
    }

    Context createContext(OutputStream output) throws IOException {
        OutputStreamWriter w = new OutputStreamWriter(output);
        return this.createContext(w);
    }

    Context createContext(Writer w) throws IOException {
        Context ctx = new Context();
        ctx.output = w;
        ctx.closeStreamAtEnd = false;
        ctx.gexf = new GEXF();
        try {
            ctx.stream = new SmartXMLWriter(w, true);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return ctx;
    }

    protected void export(Context ctx, Graph g) throws IOException {
        ctx.gexf.disable(GEXFElement.Extension.DYNAMICS);
        GraphReplay replay = new GraphReplay("replay");
        replay.addSink(ctx.gexf);
        replay.replay(g);
        try {
            ctx.gexf.export(ctx.stream);
            ctx.stream.close();
            if (ctx.closeStreamAtEnd) {
                ctx.output.close();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public void writeAll(Graph graph, String fileName) throws IOException {
        Context ctx = this.createContext(fileName);
        this.export(ctx, graph);
    }

    public void writeAll(Graph graph, OutputStream stream) throws IOException {
        Context ctx = this.createContext(stream);
        this.export(ctx, graph);
    }

    public void writeAll(Graph graph, Writer writer) throws IOException {
        Context ctx = this.createContext(writer);
        this.export(ctx, graph);
    }

    public void begin(String fileName) throws IOException {
        if (this.currentContext != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.currentContext = this.createContext(fileName);
        this.addSink(this.currentContext.gexf);
    }

    public void begin(OutputStream stream) throws IOException {
        if (this.currentContext != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.currentContext = this.createContext(stream);
        this.addSink(this.currentContext.gexf);
    }

    public void begin(Writer writer) throws IOException {
        if (this.currentContext != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.currentContext = this.createContext(writer);
        this.addSink(this.currentContext.gexf);
    }

    public void flush() throws IOException {
        if (this.currentContext != null) {
            this.currentContext.stream.flush();
        }
    }

    public void end() throws IOException {
        this.removeSink(this.currentContext.gexf);
        try {
            this.currentContext.gexf.export(this.currentContext.stream);
            this.currentContext.stream.close();
            if (this.currentContext.closeStreamAtEnd) {
                this.currentContext.output.close();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        this.currentContext = null;
    }

    class Context {
        GEXF gexf;
        Writer output;
        SmartXMLWriter stream;
        boolean closeStreamAtEnd;

        Context() {
        }
    }
}

