/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import org.graphstream.stream.file.FileSinkGML;

public class FileSinkDynamicGML
extends FileSinkGML {
    public void graphAttributeAdded(String sourceId, long timeId, String attribute, Object value) {
        this.ensureToFinish();
        String val = this.valueToString(value);
        if (val != null) {
            this.out.printf("\t%s %s%n", attribute, val);
        }
    }

    public void graphAttributeChanged(String sourceId, long timeId, String attribute, Object oldValue, Object newValue) {
        this.ensureToFinish();
        this.graphAttributeAdded(sourceId, timeId, attribute, newValue);
    }

    public void graphAttributeRemoved(String sourceId, long timeId, String attribute) {
        this.ensureToFinish();
        this.out.printf("\t-%s%n", attribute);
    }

    public void nodeAttributeAdded(String sourceId, long timeId, String nodeId, String attribute, Object value) {
        this.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, null, value);
    }

    public void nodeAttributeChanged(String sourceId, long timeId, String nodeId, String attribute, Object oldValue, Object newValue) {
        if (this.nodeToFinish == null || !this.nodeToFinish.equals(nodeId)) {
            this.ensureToFinish();
            this.out.printf("\t+node [%n", new Object[0]);
            this.out.printf("\t\tid \"%s\"%n", nodeId);
            this.nodeToFinish = nodeId;
        }
        if (newValue != null) {
            String val = this.valueToString(newValue);
            if (val != null) {
                this.out.printf("\t\t%s %s%n", attribute, val);
            }
        } else {
            this.out.printf("\t\t-%s%n", attribute);
        }
    }

    public void nodeAttributeRemoved(String sourceId, long timeId, String nodeId, String attribute) {
        this.nodeAttributeChanged(sourceId, timeId, nodeId, attribute, null, null);
    }

    public void edgeAttributeAdded(String sourceId, long timeId, String edgeId, String attribute, Object value) {
        this.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, null, value);
    }

    public void edgeAttributeChanged(String sourceId, long timeId, String edgeId, String attribute, Object oldValue, Object newValue) {
        if (this.edgeToFinish == null || !this.edgeToFinish.equals(edgeId)) {
            this.ensureToFinish();
            this.out.printf("\t+edge [%n", new Object[0]);
            this.out.printf("\t\tid \"%s\"%n", edgeId);
            this.edgeToFinish = edgeId;
        }
        if (newValue != null) {
            String val = this.valueToString(newValue);
            if (val != null) {
                this.out.printf("\t\t%s %s%n", attribute, val);
            }
        } else {
            this.out.printf("\t\t-%s%n", attribute);
        }
    }

    public void edgeAttributeRemoved(String sourceId, long timeId, String edgeId, String attribute) {
        this.edgeAttributeChanged(sourceId, timeId, edgeId, attribute, null, null);
    }

    public void nodeAdded(String sourceId, long timeId, String nodeId) {
        this.ensureToFinish();
        this.out.printf("\tnode [%n", new Object[0]);
        this.out.printf("\t\tid \"%s\"%n", nodeId);
        this.nodeToFinish = nodeId;
    }

    public void nodeRemoved(String sourceId, long timeId, String nodeId) {
        this.ensureToFinish();
        this.out.printf("\t-node \"%s\"%n", nodeId);
    }

    public void edgeAdded(String sourceId, long timeId, String edgeId, String fromNodeId, String toNodeId, boolean directed) {
        this.ensureToFinish();
        this.out.printf("\tedge [%n", new Object[0]);
        this.out.printf("\t\tid \"%s\"%n", edgeId);
        this.out.printf("\t\tsource \"%s\"%n", fromNodeId);
        this.out.printf("\t\ttarget \"%s\"%n", toNodeId);
        this.out.printf("\t\tdirected %s%n", directed ? "1" : "0");
        this.edgeToFinish = edgeId;
    }

    public void edgeRemoved(String sourceId, long timeId, String edgeId) {
        this.ensureToFinish();
        this.out.printf("\t-edge \"%s\"%n", edgeId);
    }

    public void graphCleared(String sourceId, long timeId) {
    }

    public void stepBegins(String sourceId, long timeId, double step) {
        this.ensureToFinish();
        if (step - (double)((int)step) == 0.0) {
            this.out.printf("\tstep %d%n", (int)step);
        } else {
            this.out.printf("\tstep %f%n", step);
        }
    }
}

