/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.stream.file;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.stream.file.FileSink;

public abstract class FileSinkBase
implements FileSink {
    protected Writer output;

    public void writeAll(Graph graph, String fileName) throws IOException {
        this.begin(fileName);
        this.exportGraph(graph);
        this.end();
    }

    public void writeAll(Graph graph, OutputStream stream) throws IOException {
        this.begin(stream);
        this.exportGraph(graph);
        this.end();
    }

    public void writeAll(Graph graph, Writer writer) throws IOException {
        this.begin(writer);
        this.exportGraph(graph);
        this.end();
    }

    protected void exportGraph(Graph graph) {
        String graphId = graph.getId();
        long timeId = 0L;
        for (String key : graph.getAttributeKeySet()) {
            this.graphAttributeAdded(graphId, timeId++, key, graph.getAttribute(key));
        }
        for (Node node : graph) {
            String nodeId = node.getId();
            this.nodeAdded(graphId, timeId++, nodeId);
            if (node.getAttributeCount() <= 0) continue;
            for (String key : node.getAttributeKeySet()) {
                this.nodeAttributeAdded(graphId, timeId++, nodeId, key, node.getAttribute(key));
            }
        }
        for (Edge edge : graph.getEachEdge()) {
            String edgeId = edge.getId();
            this.edgeAdded(graphId, timeId++, edgeId, edge.getNode0().getId(), edge.getNode1().getId(), edge.isDirected());
            if (edge.getAttributeCount() <= 0) continue;
            for (String key : edge.getAttributeKeySet()) {
                this.edgeAttributeAdded(graphId, timeId++, edgeId, key, edge.getAttribute(key));
            }
        }
    }

    public void begin(String fileName) throws IOException {
        if (this.output != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.output = this.createWriter(fileName);
        this.outputHeader();
    }

    public void begin(OutputStream stream) throws IOException {
        if (this.output != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.output = this.createWriter(stream);
        this.outputHeader();
    }

    public void begin(Writer writer) throws IOException {
        if (this.output != null) {
            throw new IOException("cannot call begin() twice without calling end() before.");
        }
        this.output = this.createWriter(writer);
        this.outputHeader();
    }

    public void flush() throws IOException {
        if (this.output != null) {
            this.output.flush();
        }
    }

    public void end() throws IOException {
        this.outputEndOfFile();
        this.output.flush();
        this.output.close();
        this.output = null;
    }

    protected abstract void outputHeader() throws IOException;

    protected abstract void outputEndOfFile() throws IOException;

    protected Writer createWriter(String fileName) throws IOException {
        return new PrintWriter(fileName);
    }

    protected Writer createWriter(OutputStream stream) throws IOException {
        return new PrintWriter(stream);
    }

    protected Writer createWriter(Writer writer) throws IOException {
        if (writer instanceof PrintWriter) {
            return writer;
        }
        return new PrintWriter(writer);
    }
}

