package cec2013;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Wrapper4Nomad {
	/** Always Initialise a CEC2013 object **/
	static CEC2013 comp = new CEC2013();
	/** Get the function list **/
	static List< Func > funcs = comp.getFunctions();
	
	//---main for wrapping NOMAD
	public static void main(String[] args) {
		
		if (args.length != 2) {
			System.err.println("Usage: cec2013.Wrapper4Nomad <input file> <Function number Cec2013>");
			System.exit(1);
		}
		
		int function = Integer.parseInt(args[1]);
		
		// The -1 is cause e.g. F1 has an index 0, or F2 an index 1
		Func f = funcs.get(function-1);
		
		File fpt = new File(args[0]);
		double[] x = null;
		//System.out.println(fpt.toString());
		try {
			Scanner input = new Scanner(fpt);
			List<String> values = getTagValues(input.nextLine());
			Iterator<String> it = values.iterator();
			
			x = new double[values.size()];
			for (int i=0;it.hasNext();i++) {
				String v = it.next().trim();
				//System.out.println(v);
				x[i] = Double.parseDouble(v);
			}
			input.close();
			
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		double fitness = f.evaluate(x);
		
		// Fitness: 
		//			- cec2013 are maximization problems
		//			- we multiply by -1 to transform the problem into minimization for nomad
		System.out.print((-1.0*fitness));
		// nomad demands some extra values
		// I don't remember the utility but 0 stands for everything went OK
		for(int i=0;i<x.length;i++) {
			System.out.print(" 0");
		}
		System.out.println();
	}
	
	private static final Pattern TAG_REGEX = Pattern.compile("(.+?)(\\s|$)");

	private static List<String> getTagValues(final String str) {
	    final List<String> tagValues = new ArrayList<String>();
	    final Matcher matcher = TAG_REGEX.matcher(str);
	    while (matcher.find()) {
	        tagValues.add(matcher.group(1));
	    }
	    return tagValues;
	}
}
