package multinomad.tools;

import java.util.List;
import multinomad.individuals.Population;

public abstract class Function {
	protected int findex = -1;
	protected List<ClosedInterval.Double > bounds;
	protected int dimension;
	protected int noOptima;
	protected long nEvals=0;
	
	public Function() {
		// TODO Auto-generated constructor stub
	}
	
	public Function(int index) {
		findex = index;
	}
	

	public List<ClosedInterval.Double > getBounds() {
		return bounds;
	}
	
	public int getDimension(){
		return dimension;
	}
	
	public int getNoOptima() {
		return noOptima;
	}
	
	public long getNEvals() {
		return nEvals;
	}
	
	
	public abstract double evaluate(double[] x) ;
	
	public abstract double[] evaluateAPopulation(Population pop);	
	
	public abstract Seeds how_many_goptima(Population p, double accuracy);

}
