package multinomad.individuals;

import java.util.ArrayList;

import multinomad.config.Configuration;

public class Trajectory {
	private ArrayList<DoubleIndividual> trajectory;
	private int indexbest = -1;

	public Trajectory() {
		trajectory = new ArrayList<DoubleIndividual>();
	}
	
	public void parseAndAdd(String pointNomadFormat) {

		//System.out.println("-> "+pointNomadFormat);
		if (pointNomadFormat.contains("(")) { // If this is a white line there is nothing to parse 
			double []x = new double[Configuration.f.getDimension()];
			double fitness;
			String[] elements = pointNomadFormat.substring(pointNomadFormat.indexOf("(")+1, pointNomadFormat.indexOf(")")-1).trim().split(" ");
			String fitnessValue = pointNomadFormat.substring(pointNomadFormat.lastIndexOf(')')+1);
			
			// Warning: 
				// we multiply fitness by -1 cause Cec2013 is a maximization benchmark and Nomad a minimization framework
				// TODO: Look if there is a way to set Nomad as a maximization solver.
			fitness = -1.0*Double.parseDouble(fitnessValue);  
			for(int i=0;i<elements.length;i++) {
				x[i] = Double.parseDouble(elements[i]);
			}
			
			DoubleIndividual ind = new DoubleIndividual(x);
			ind.setFitness(fitness);
			
			trajectory.add(ind);		
			if (indexbest == -1)
				indexbest = 0;
			if (trajectory.get(indexbest).getFitness() <  fitness)
				indexbest = trajectory.size()-1;
		}
	}
	
	public DoubleIndividual getBest() {
		return trajectory.get(indexbest);
	}
	
	public ArrayList<DoubleIndividual> asArrayList(){
		return trajectory;
	}
	
}
