/*
EvoGen, Evolutionary Geneura is a framework for simulating distributed evolutionary computation experiments
Copyright (C) 2008 Junta de Andalucia CICE project P06-TIC-02025

This file is part of EvoGen.

EvoGen is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

EvoGen is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with EvoGen; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

contact:  http://geneura.ugr.es, https://forja.rediris.es/svn/geneura/evogen
*/
package multinomad.individuals;

import java.util.ArrayList;

import multinomad.config.Configuration;
import multinomad.tools.ClosedInterval;
import multinomad.tools.CommonState;



public class DoubleChromosome {

	private double[] gens;
	
	
	public DoubleChromosome() {
		gens = new double [Configuration.f.getDimension()];
		
		int index = 0;
		for(ClosedInterval.Double i : Configuration.f.getBounds()){
			gens[index] = (CommonState.r.nextDouble()*(i.upper-i.lower))+i.lower;
			index++;
		}
	}
	
	public DoubleChromosome(double[] genes){
		gens = new double [genes.length];
		for(int i=0; i<genes.length; i++){
			gens[i] = genes[i];
		}
	}
	

	public int getLength() {
		return gens.length;
	}

	public Object clone(){
		DoubleChromosome bin = new DoubleChromosome(this.asdouble());
		return bin;
	}
	
	public boolean equals(Object obj) {
		if (obj instanceof DoubleChromosome) {
			DoubleChromosome chr = (DoubleChromosome) obj;
			if(chr.getLength() == this.getLength()){
				for(int i=0;i<this.getLength();i++)
					if(chr.gens[i] != this.gens[i])
					 return false;
			}else{
				return false;
			}
		}else{
			return false;
		}
		return true;
	}


	public double[] asdouble() {
		return gens;
	}
	
	public String asPyString() {
		String str=""+gens[0];
		for(int i=1;i<gens.length;i++)
			str+=","+gens[i];
		return str;
	}
	
	public ArrayList<Double> asArrayListDouble() {
		ArrayList<Double> toreturn = new ArrayList<Double>();
		
		for(int i=0;i<gens.length;i++) 
			toreturn.add(new Double(gens[i]));
		
		return toreturn;
	}

}
