package multinomad.algorithms;

import java.util.ArrayList;
import java.util.regex.Pattern;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;
import multinomad.individuals.DoubleIndividual;
import multinomad.individuals.Population;
import multinomad.individuals.Trajectory;
import multinomad.tools.Nomad;
import multinomad.tools.Seeds;

public class SimpleMultiHillClimbers implements Runnable{

		
	public void run() {
		
		long start = System.currentTimeMillis();
		System.out.println("Starting:");
		Population pop = new Population(true);
		System.out.println("[POP] Elapsed time: "+(System.currentTimeMillis()-start));
		start = System.currentTimeMillis();
		Population solutions = new Population(false);
		System.out.println("[Solutions] Elapsed time: "+(System.currentTimeMillis()-start));
		start = System.currentTimeMillis();
		
		for(DoubleIndividual ind : pop) {
			System.out.println("Initial:\t\t"+ ind.asString());
		}
		
		for(DoubleIndividual ind : pop) {
			// Performs a hill-climber 
			Trajectory trajectory = Nomad.callPyNomadCec2013(ind.getChr().asdouble(), 0.1, 100);
			DoubleIndividual result = trajectory.getBest();
			result.setFitness(Configuration.f.evaluate(result.getChr().asdouble()));
			// Shows results
			System.out.println("Result:\t\t"+ result.asString());
			//System.out.println("[Trajectory] Elapsed time: "+(System.currentTimeMillis()-start));
			start = System.currentTimeMillis();
			
			solutions.add(result);
		}

		Seeds seeds = Configuration.f.how_many_goptima(solutions, 0.01);
		
		System.out.println("Found "+seeds.getCount()+" optima");
		
//		if (numberOfOptima == Configuration.comp.getNoGoptima(Configuration.indexf)) {
//			System.out.println("Success: "+ numberOfOptima + " optima were found");	
//		}else {
//			System.out.println("Failure: "+ numberOfOptima + " out of "+ Configuration.comp.getNoGoptima(Configuration.indexf) +" optima were found");	
//		}
		
	}
	
	
	
	
	
	
	public static void main(String[] args) {
		//System.out.println(Pattern.quote("["));
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);
		SimpleMultiHillClimbers smhc = new SimpleMultiHillClimbers();
		Thread t1 =new Thread(smhc);  
		t1.start();		
	}
	

}
