package multinomad.algorithms;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;
import multinomad.tools.ICDFtriangular;
import multinomad.tools.cec2013.BasinsTriangularDistribution;

public class SamplingTriangularSR098 implements Runnable {
	private static final double SR = 0.98;

	public void run() {
		
		for(int m=2;m<=100;m++) {
			Configuration.m = m;
			Configuration.noOptima = m;
			double A = ICDFtriangular.calculateA(Configuration.m, Configuration.ratio, Configuration.c);
			double[] probabilities = ICDFtriangular.probabilities(Configuration.m, Configuration.ratio, Configuration.c);
			BasinsTriangularDistribution basin = new BasinsTriangularDistribution(probabilities, A);

			int nupperbound = -1 ,nestimate = -1;
			boolean upper = false, estimate = false; 
			for(int i=0;i<100000;i++) {
				
				if (!upper && basin.upperProbability(i) >= SR) {
					upper = true;
					nupperbound = i;
				}
				
				if (!estimate && basin.estimateProbabilityEq1(i) >= SR) {
					estimate = true;
					nestimate = i;
				}

				if(upper && estimate)
					break;
			}
			
			System.out.println(m+" "+nupperbound+" "+nestimate);
			
		}
	
	}

	public static void main(String[] args) {
		//System.out.println(Pattern.quote("["));
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);
		SamplingTriangularSR098 sampling = new SamplingTriangularSR098();
		Thread t1 =new Thread(sampling);  
		t1.start();		
	}

}
