package multinomad.tools.cec2013;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;

public class BasinsF7 extends Basins {
	
	// We approximate the coordinates of every basin with a square 
	// Every basin is limited therefore using 2 coordinates: 
	// The lower (lx0,lx1) and the upper (ux0,ux1) corners of the square  
	private static final double[][] BASINS = {
			{0.29375,0.29375,0.40625,0.40625},               // 1
			{0.565625,0.29375,0.734375,0.40625},             // 2
			{1.03125,0.29375,1.3687500000000001,0.40625},            // 3
			{1.8625,0.29375,2.5375,0.40625},                 // 4
			{3.546875,0.29375,4.953125,0.40625},             // 5
			{6.51875,0.29375,8.88125,0.40625},               // 6
			{0.29375,0.565625,0.40625,0.734375},             // 7
			{0.565625,0.565625,0.734375,0.734375},           // 8
			{1.03125,0.565625,1.3687500000000001,0.734375},          // 9
			{1.8625,0.565625,2.5375,0.734375},               // 10
			{3.546875,0.565625,4.953125,0.734375},           // 11
			{6.51875,0.565625,8.88125,0.734375},             // 12
			{0.29375,1.03125,0.40625,1.3687500000000001},            // 13
			{0.565625,1.03125,0.734375,1.3687500000000001},          // 14
			{1.03125,1.03125,1.3687500000000001,1.3687500000000001},                 // 15
			{1.8625,1.03125,2.5375,1.3687500000000001},              // 16
			{3.546875,1.03125,4.953125,1.3687500000000001},          // 17
			{6.51875,1.03125,8.88125,1.3687500000000001},            // 18
			{0.29375,1.8625,0.40625,2.5375},                 // 19
			{0.565625,1.8625,0.734375,2.5375},               // 20
			{1.03125,1.8625,1.3687500000000001,2.5375},              // 21
			{1.8625,1.8625,2.5375,2.5375},           // 22
			{3.546875,1.8625,4.953125,2.5375},               // 23
			{6.51875,1.8625,8.88125,2.5375},                 // 24
			{0.29375,3.546875,0.40625,4.953125},             // 25
			{0.565625,3.546875,0.734375,4.953125},           // 26
			{1.03125,3.546875,1.3687500000000001,4.953125},          // 27
			{1.8625,3.546875,2.5375,4.953125},               // 28
			{3.546875,3.546875,4.953125,4.953125},           // 29
			{6.51875,3.546875,8.88125,4.953125},             // 30
			{0.29375,6.51875,0.40625,8.88125},               // 31
			{0.565625,6.51875,0.734375,8.88125},             // 32
			{1.03125,6.51875,1.3687500000000001,8.88125},            // 33
			{1.8625,6.51875,2.5375,8.88125},                 // 34
			{3.546875,6.51875,4.953125,8.88125},             // 35
			{6.51875,6.51875,8.88125,8.88125},               // 36
			};
	
	
	
	public BasinsF7() {
		super(BASINS);
	}

	@Override
	public double upperNumberOfSamplesBound(double probability) {
		// TODO Auto-generated method stub
		return 0;
	}



	@Override
	public double lowerNumberOfSamplesBound(double probability) {
		// TODO Auto-generated method stub
		return 0;
	}
	
	public static void main(String[] args) {

		// Uncomment to print the constraints
//		for(int i=0;i<BasinsF7.BASINS.length;i++) {
//			System.out.println(BASINS[i][0]+" "+BASINS[i][1]);
//			System.out.println(BASINS[i][2]+" "+BASINS[i][3]);
//		}

		// Uncomment to recalculate the basins
//		for(int i=0;i<BasinsF7.BASINS.length;i++) {
//			printConstraints(BasinsF7.BASINS[i], 0.25, i+1);
//		}
		
		// Uncomment to calculate upper and lower bound
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);

		BasinsF7 basin = new BasinsF7();
		
		for(int i=0;i<50000;i++) {
			double upperprobability = basin.upperProbability(i);
			double lowerprobability = basin.lowerProbability(i);
			double estimateProbabilityEq1 = basin.estimateProbabilityEq1(i);
//			double estimateMedian = basin.estimateProbabilityBasedOnMedian(i);
//			double estimatePercentile10 = basin.estimateProbabilityBasedOnPercentile10(i);
//			double estimatePercentile20 = basin.estimateProbabilityBasedOnPercentile20(i);
//			double estimatePercentile30 = basin.estimateProbabilityBasedOnPercentile30(i);
//			double estimatePercentile40 = basin.estimateProbabilityBasedOnPercentile40(i);
			System.out.println(i+" "+lowerprobability+" "+upperprobability+" "+estimateProbabilityEq1);
		}
		
	}
	
	private static void printConstraints(double[] constraints, double rateOfReduction, int n) {
		double xinf = constraints[0];
		double yinf = constraints[1];
		double xsup = constraints[2];
		double ysup = constraints[3];
		
		double xgap = (xsup - xinf)*(rateOfReduction/2.0);
		double ygap = (ysup - yinf)*(rateOfReduction/2.0);
		
		double[] nc = {xinf+xgap,yinf+ygap,xsup-xgap,ysup-ygap};
		
		System.out.println("{"+nc[0]+","+nc[1]+","+nc[2]+","+nc[3]+"},\t\t // "+n);
	}



	

}
