package multinomad.tools.cec2013;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;

public class BasinsF6 extends Basins {
	
	// We approximate the coordinates of every basin with a square 
	// Every basin is limited therefore using 2 coordinates: 
	// The lower (lx0,lx1) and the upper (ux0,ux1) corners of the square  
	private static final double[][] BASINS = {
			{-8,-7.35,-7.45,-6.8}, 					// 1st basin
			{-7.35,-8,-6.8,-7.45},	 				// 2nd basin
			{-8,-1.05,-7.45,-0.5}, 					// 3
			{-7.35,-1.7,-6.8,-1.25}, 				// 4
			{-8,5.2,-7.45,5.75}, 					// 5
			{-7.35,4.55,-6.8,5.1},		 			// 6
			{-1.7,-7.35,-1.25,-6.8},	 			// 7
			{-1.05,-8,-0.5,-7.45},		 			// 8
			{-1.7,-1.05,-1.25,-0.5},	 			// 9
			{-1.05,-1.7,-0.5,-1.25},	 			// 10
			{-1.7,5.2,-1.25,5.75},		 			// 11
			{-1.05,4.55,-0.5,5.1},		 			// 12
			{4.55,-7.35,5.1,-6.8},		 			// 13
			{5.2,-8,5.75,-7.45},					// 14
			{4.55,-1.05,5.1,-0.5},		 			// 15
			{5.2,-1.7,5.75,-1.25},		 			// 16
			{4.55,5.2,5.1,5.75},		 			// 17
			{5.2,4.55,5.75,5.1}  					// 18
			};
	
	
	
	public BasinsF6() {
		super(BASINS);
	}

	@Override
	public double upperNumberOfSamplesBound(double probability) {
		// TODO Auto-generated method stub
		return 0;
	}



	@Override
	public double lowerNumberOfSamplesBound(double probability) {
		// TODO Auto-generated method stub
		return 0;
	}
	
	public static void main(String[] args) {
		// Uncomment to print the constraints
//		for(int i=0;i<BasinsF6.BASINS.length;i++) {
//			System.out.println(BASINS[i][0]+" "+BASINS[i][1]);
//			System.out.println(BASINS[i][2]+" "+BASINS[i][3]);
//		}

		// Uncomment to recalculate the basins
//		for(int i=0;i<BasinsF6.BASINS.length;i++) {
//			printConstraints(BasinsF6.BASINS[i], 0.25, i+1);
//		}
		
		// Uncomment to calculate upper and lower bound
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);

		BasinsF6 basin = new BasinsF6();
		
		for(int i=0;i<50000;i++) {
			double upperprobability = basin.upperProbability(i);
			double lowerprobability = basin.lowerProbability(i);
			double estimateProbabilityEq1 = basin.estimateProbabilityEq1(i);
//			double estimateMedian = basin.estimateProbabilityBasedOnMedian(i);
//			double estimatePercentile10 = basin.estimateProbabilityBasedOnPercentile10(i);
//			double estimatePercentile20 = basin.estimateProbabilityBasedOnPercentile20(i);
//			double estimatePercentile30 = basin.estimateProbabilityBasedOnPercentile30(i);
//			double estimatePercentile40 = basin.estimateProbabilityBasedOnPercentile40(i);
			System.out.println(i+" "+lowerprobability+" "+upperprobability+" "+estimateProbabilityEq1);
		}
		
	}



	

}
