package multinomad.tools.cec2013;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;

public class BasinsF10 extends Basins {
	
	//Modified Rastrigin

	// We approximate the coordinates of every basin with a square 
	// Every basin is limited therefore using 2 coordinates: 
	// The lower (lx0,lx1) and the upper (ux0,ux1) corners of the square  
	private static final double[][] BASINS = {
			{0,0,0.33,0.25}, 					// 1st basin
			{.33,0,.66,0.25},	 				// 2nd basin
			{.66,0,1,.25},	 					// 3
			{0,.25,.33,.5}, 					// 4
			{.33,.25,.66,.5}, 					// 5
			{.66,.25,1,.5},		 				// 6
			{0,.5,.33,.75}, 					// 7
			{.33,.5,.66,.75}, 					// 8
			{.66,.5,1,.75},		 				// 9
			{0,.75,.33,1}, 						// 10
			{.33,.75,.66,1}, 					// 11
			{.66,.75,1,1},		 				// 12
			};
	
	public BasinsF10() {
		super(BASINS);
	}
	
	@Override
	public double upperNumberOfSamplesBound(double probability) {
		// TODO Auto-generated method stub
		return 0;
	}

	@Override
	public double lowerNumberOfSamplesBound(double probability) {
		// TODO Auto-generated method stub
		return 0;
	}

	
	public static void main(String[] args) {
		
		// Uncomment to calculate upper and lower bound
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);

		BasinsF10 basin = new BasinsF10();
		
		for(int i=0;i<10000;i++) {
			double upperprobability = basin.upperProbability(i);
			double lowerprobability = basin.lowerProbability(i);
			double estimateProbabilityEq1 = basin.estimateProbabilityEq1(i);
//			double estimateMedian = basin.estimateProbabilityBasedOnMedian(i);
//			double estimatePercentile10 = basin.estimateProbabilityBasedOnPercentile10(i);
//			double estimatePercentile20 = basin.estimateProbabilityBasedOnPercentile20(i);
//			double estimatePercentile30 = basin.estimateProbabilityBasedOnPercentile30(i);
//			double estimatePercentile40 = basin.estimateProbabilityBasedOnPercentile40(i);
			System.out.println(i+" "+lowerprobability+" "+upperprobability+" "+estimateProbabilityEq1);
		}
		
	}
}
