package multinomad.tools;

import java.util.ArrayList;
import java.util.List;

import cec2013.CEC2013;
import cec2013.Func;
import multinomad.config.Configuration;
import multinomad.individuals.DoubleIndividual;
import multinomad.individuals.Population;

public class JavaFunction extends Function {

	//Cec2013 java compatibility
	static CEC2013 comp = new CEC2013();
	static List< Func > funcs = comp.getFunctions();
	private Func f;
		
	public JavaFunction() {
		super();
	}
	
	public JavaFunction(int index) {
		super(index);
		bounds = new ArrayList<ClosedInterval.Double >();
		f = funcs.get(findex-1);
		dimension = f.getDimension();
		noOptima = comp.getNoGoptima(findex);
		List<cec2013.ClosedInterval.Double> doubleBounds =	f.getBounds();
		System.out.println("Tamaño "+doubleBounds.size());
		for (cec2013.ClosedInterval.Double aBound : doubleBounds) {
			ClosedInterval.Double newBound = new ClosedInterval.Double(aBound.lower, aBound.upper);
			bounds.add(newBound);
		}
		
	}
	

	public double evaluate(double[] x) {
		nEvals++;
		return f.evaluate(x);
	}

	@Override
	public double[] evaluateAPopulation(Population pop) {
		//Fitness value to calculate
		double [] fitnesses = new double[pop.size()];
		
		int i = 0;
		for(DoubleIndividual ind: pop) {
			fitnesses[i] = this.evaluate(ind.getChr().asdouble());
			ind.setFitness(fitnesses[i]);
			i++;
		}
		
		return fitnesses;
	}

	@Override
	public Seeds how_many_goptima(Population p, double accuracy) {
		// TODO Auto-generated method stub
		return new Seeds(p,findex-1, Configuration.accuracy, true);
	}

}
