package multinomad.tools;

public class ICDFtriangular {
	
	public static double[] probabilities(int m, double ratio, double c) {
		double [] p_i = new double[m];
		double A = calculateA(m, ratio, c);
		
		for(int i=1;i<=m;i++) {
			p_i[i-1] = icdf(((i*1.0)/(m+1)),c)/A;
		}
		
		return p_i;
	}
	
	public static double calculateA(int m, double ratio, double c) {
		double summatory = 0;
		for(int i=1;i<=m;i++) {
			summatory += icdf(((i*1.0)/(m+1)),c);
		}
		
		double A= summatory / ratio;
		return A;
	}
	
	public static double icdf(double alpha,double c) {
		if (alpha < c) {
			return Math.sqrt(alpha*c);
		}else {
			return 1-Math.sqrt((1-alpha)*(1-c));
		}
	}

}
