/*
EvoGen, Evolutionary Geneura is a framework for simulating distributed evolutionary computation experiments
Copyright (C) 2008 Junta de Andalucia CICE project P06-TIC-02025

This file is part of EvoGen.

EvoGen is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

EvoGen is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with EvoGen; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

contact:  http://geneura.ugr.es, https://forja.rediris.es/svn/geneura/evogen
*/
package multinomad.config;

import multinomad.tools.CommonState;
import multinomad.tools.Function;
import multinomad.tools.JavaFunction;
import multinomad.tools.LoisFunction;
import multinomad.tools.LoisFunctionBench;
import multinomad.tools.PyFunction;

public class Configuration {
	
	/** Accuracies **/
	public static final double[] accuracies = {1.0E-01,1.0E-02,1.0E-03,1.0E-04,1.0E-05};
	
	public static final String KMEANSPLUS= "kmeansplus";
	public static final String KMEANSRANDOM= "kmeansrandom";
	
	public static final String KMEANSLLOYD= "kmeanslloyd";
	public static final String KMEANSBIASED= "kmeansbiased";
	
	public static final String COOPERATIVE="cooperative";
	public static final String TOURNAMENT="tournament";
	
	public static final String JAVACEC2013="javacec2013";
	public static final String PYTHONCEC2013="pythoncec2013";
	public static final String LOISFUNCTION="loisfunction";
	public static final String LOISFUNCTIONBENCH="loisfunctionbench";
	
	// --- Parameters:
	// - indexf is the index of the function
	public static int indexf = 1;
	public static Function f;
	public static double accuracy = 1.0E-01;
	
	public static int Psize;
	public static int tournamentSize;
	public static String functionname = "javacec2013";
	
	// Selection can be cooperative or tournament
	public static String selection;
	
	// Method to initialize kmeans can take the values:
	//					-kmeansplus
	//					-kmeansrandom
	public static String kmeansinit;
	
	// Method for convergence of kmeans can take the values:
	//					-kmeanlloyd
	//					-kmeansbiased
	public static String kmeansconvergence;
	
	
	// [Sampling tests] Name of the Basin class  
	//					- BasinsF6 
	//					- BasinsF7
	//					- BasinsTriangularDistribution
	public static String basin;
	
	// [Sampling tests] parameter m or no. of basins
	public static int m;
	
	// [Sampling tests] parameter ratio
	public static double ratio;
	
	// [Sampling tests] [Triangular Distribution] parameter c (mode)
	public static double c;
	
	public static double noOptima;
		
	public static void setConfiguration(LoadProperties lp){	
		CommonState.setSeed(System.currentTimeMillis());
		indexf = Integer.parseInt(lp.getProperty("F", "1"));
		accuracy = Double.parseDouble(lp.getProperty("accuracy", "1.0E-01"));
		Psize = Integer.parseInt(lp.getProperty("Psize", "20"));
		selection = lp.getProperty("selection", "tournament");
		tournamentSize = Integer.parseInt(lp.getProperty("tournamentsize", "20"));
		functionname = lp.getProperty("functionname", "javacec2013");
		kmeansinit = lp.getProperty("kmeansinit", "kmeansrandom");
		kmeansconvergence = lp.getProperty("kmeansconvergence", "kmeanslloyd");
		basin = lp.getProperty("basin", "");
		m = Integer.parseInt(lp.getProperty("m", "-1"));
		ratio = Double.parseDouble(lp.getProperty("ratio", "0.2"));
		c = Double.parseDouble(lp.getProperty("c", "0.1"));
	
		
		if (functionname.equals(JAVACEC2013))
			f = new JavaFunction(indexf);
		else if (functionname.equals(PYTHONCEC2013))
			f = new PyFunction(indexf);
		else if (functionname.equals(LOISFUNCTION))
			f = new LoisFunction();
		else if (functionname.equals(LOISFUNCTIONBENCH))
			f = new LoisFunctionBench();
		
		noOptima = f.getNoOptima();
		
		if (m > 0)
			noOptima = m;
		
	}
	
	
	
	

}
