package multinomad.algorithms;

import java.util.ArrayList;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;
import multinomad.individuals.DoubleIndividual;
import multinomad.individuals.Population;
import multinomad.tools.cec2013.Basins;


public class SamplingTest implements Runnable{
	
	public void run() {
		
		int noOfTouchedBasins = testonepopulation();
		int noOfActualBasins = Configuration.f.getNoOptima();
		
		if (noOfTouchedBasins == noOfActualBasins) {
			System.out.println("SUCCESS 1 PEAK RATIO 1.0");
		}else {
			System.out.println("FAILURE 0 PEAK RATIO " + (noOfTouchedBasins/(noOfActualBasins*1.0)) );
		}
		
	}
	
	/**
	 * 
	 * @return the number of basins that has been sampled
	 */
	public static int testonepopulation() {
		// Method for testing 
				Population pop = new Population(true);
				for(DoubleIndividual ind : pop) {
					//System.out.println("Initial:\t\t"+ ind.asString());
				}
				
				SamplingTest st = new SamplingTest();
				
				Basins basins = st.loadClass();
				
				return basins.getNoOfSampledBasinsIn(pop.getP());
	}
	
	private Basins loadClass() {
		ClassLoader loader = ClassLoader.getSystemClassLoader();
		Class[] basins_args = {};
		Object[] basins_obj = new Object[]{};
		Basins basins = null;
		
		try {
			basins = (Basins) loader.loadClass("multinomad.tools.cec2013."+Configuration.basin)
			.getConstructor(basins_args)
			.newInstance(basins_obj);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		return basins;
	}

	
	
	public static void main(String[] args) {
		//System.out.println(Pattern.quote("["));
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);
		SamplingTest sampling = new SamplingTest();
		Thread t1 =new Thread(sampling);  
		t1.start();		
	}
}
