package multinomad.algorithms;

import multinomad.config.Configuration;
import multinomad.config.LoadProperties;
import multinomad.individuals.DoubleIndividual;
import multinomad.individuals.Population;
import multinomad.tools.ClosedInterval;
import multinomad.tools.CommonState;

public class ContourSectionHyperplane implements Runnable{
	
	public void run() {
		
		// Step 1: Explore the landscape with a large population
		double[] x_aux = new double[Configuration.f.getDimension()];
		int index = 0;
		for(ClosedInterval.Double i : Configuration.f.getBounds()){
			x_aux[index] = (CommonState.r.nextDouble()*(i.upper-i.lower))+i.lower;
			index++;
		}
		
		
//		double []x_aux = {0.4, 0.9, 0.24, 126.5, -86, -49, -4.3, -13.01, -51.7, -82.2, 22.8, -29.9, 10.8, -3.3};
		
		
		
			Population pop = new Population(10,11,x_aux);
			//for(DoubleIndividual ind : pop) {
				//System.out.println("Contour:\t\t"+ ind.asString());
			//}
	}
	
	public static void main(String[] args) {
		//System.out.println(Pattern.quote("["));
		LoadProperties lp = new LoadProperties(args,null);
		Configuration.setConfiguration(lp);
		ContourSectionHyperplane contour = new ContourSectionHyperplane();
		Thread t1 =new Thread(contour);  
		t1.start();		
	}

}
