/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.evaluation;

import net.sf.javaml.clustering.evaluation.ClusterEvaluation;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.distance.DistanceMeasure;

public class MinMaxCut
implements ClusterEvaluation {
    private DistanceMeasure dm;

    public MinMaxCut(DistanceMeasure dm) {
        this.dm = dm;
    }

    @Override
    public double score(Dataset[] datas) {
        double sum = 0.0;
        for (int i = 0; i < datas.length; ++i) {
            double tmpTop = 0.0;
            double tmp = 0.0;
            for (int j = 0; j < datas[i].size(); ++j) {
                int k;
                for (k = 0; k < datas.length; ++k) {
                    for (int p = 0; p < datas[k].size(); ++p) {
                        if (datas[i].instance(j) == datas[k].instance(p)) continue;
                        double error = this.dm.measure(datas[i].instance(j), datas[k].instance(p));
                        tmpTop += error;
                    }
                }
                for (k = 0; k < datas[i].size(); ++k) {
                    double error = this.dm.measure(datas[i].instance(j), datas[i].instance(k));
                    tmp += error;
                }
            }
            double tmpSum = tmpTop / tmp;
            sum += tmpSum;
        }
        return sum;
    }

    @Override
    public boolean compareScore(double score1, double score2) {
        return score2 < score1;
    }
}

