/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.classification.bayes;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import net.sf.javaml.classification.bayes.AbstractBayesianClassifier;
import net.sf.javaml.classification.bayes.BayesKSolution;
import net.sf.javaml.classification.bayes.BayesNet;
import net.sf.javaml.classification.bayes.ClassCounter;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.Instance;

public class KDependentBayesClassifier
extends AbstractBayesianClassifier {
    private double treshold;
    private int[] kparents;
    private int currentWorkingK = 0;
    private int maxkparents;

    public KDependentBayesClassifier(boolean sparse, double treshold, int[] kparents) {
        super(true, true, sparse);
        this.kparents = kparents;
        this.treshold = treshold;
        this.maxkparents = kparents[0];
        for (int i = 0; i < kparents.length; ++i) {
            if (kparents[i] <= this.maxkparents) continue;
            this.maxkparents = kparents[i];
        }
    }

    @Override
    public void buildClassifier(Dataset data) {
        super.buildClassifier(data);
        this.buildBayesianNetworks();
    }

    private void buildBayesianNetworks() {
        System.out.println("Start calculating MI/CMI");
        this.calculateNeededCMIbyMIorder();
        Vector<Integer> usedFeatures = this.trainResult.getUsedFeatures_SortedMI();
        HashMap<Integer, Object[]> ImaxLL = this.trainResult.getBNBB_XiXjinS_SortedCMI();
        System.out.println("Start building BN");
        BayesNet BN = this.trainResult.getBayesNet(this.kparents[0]).getBN().cloon();
        BN.setIC(this.numFeatures, this.initialCap);
        for (int r = 0; r < this.kparents.length; ++r) {
            if (this.kparents[r] == 0) continue;
            for (int o = 1; o < usedFeatures.size(); ++o) {
                Integer Imax = usedFeatures.get(o);
                Object[] nextXjArray = ImaxLL.get(Imax);
                int endAmountOfEdges = Math.min(this.kparents[r], nextXjArray.length);
                int beginAmountOfEdges = r == 0 ? 0 : this.kparents[r - 1];
                for (int index = beginAmountOfEdges; index <= endAmountOfEdges - 1; ++index) {
                    BN.addParent(Imax, (Integer)nextXjArray[index]);
                }
            }
            this.trainResult.getBayesNet(this.kparents[r]).setBN(BN.cloon());
        }
    }

    private void calculateNeededCMIbyMIorder() {
        LinkedList<Integer> MI = this.calculateMutualInformation_Elvira();
        BayesNet BN = new BayesNet();
        Vector<Integer> usedFeatures = new Vector<Integer>(this.numFeatures);
        Iterator MIIt = MI.iterator();
        HashMap<Integer, Object[]> ImaxLL = new HashMap<Integer, Object[]>(this.initialCap);
        while (usedFeatures.size() < MI.size() && MIIt.hasNext()) {
            int Imax = (Integer)MIIt.next();
            if (!BN.getNodes().contains(Imax)) {
                BN.addNode(Imax);
            }
            int m = Math.min(usedFeatures.size(), this.maxkparents);
            LinkedList<Integer> usedFeatures_SortedCMIvalueListLL = this.calculateCMI_Memory(Imax, (Vector)usedFeatures.clone(), m);
            Object[] usedFeatures_SortedCMIvalueA = usedFeatures_SortedCMIvalueListLL.toArray();
            ImaxLL.put(Imax, usedFeatures_SortedCMIvalueA);
            usedFeatures.add(Imax);
        }
        this.trainResult.setBNBB_XiXjinS_SortedCMI(ImaxLL);
        this.trainResult.setUsedFeatures_SortedMI(usedFeatures);
        for (int r = 0; r < this.kparents.length; ++r) {
            this.trainResult.setBayesNet(new BayesKSolution(BN, null), this.kparents[r]);
        }
    }

    private LinkedList<Integer> calculateMutualInformation_Elvira() {
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        double[] freq = (double[])this.trainResult.getClassFreqs().clone();
        NavigableMap sMap = new TreeMap().descendingMap();
        int fncount = 0;
        double clsum = 0.0;
        for (int j = 0; j < this.numClasses; ++j) {
            double probCj = freq[j] / (double)this.numInstances;
            if (probCj == 0.0) continue;
            clsum += probCj * (Math.log(probCj) / Math.log(10.0));
        }
        for (Integer key : featureName_HT.keySet()) {
            ++fncount;
            int FN = key;
            double info = 0.0;
            int nClasses = this.numClasses;
            Iterator<Double> i$ = featureName_HT.get(FN).keySet().iterator();
            while (i$.hasNext()) {
                Double key2;
                Double FV = key2 = i$.next();
                double probXi = 0.0;
                for (int j = 0; j < nClasses; ++j) {
                    double probXi_temp = featureName_HT.get(FN).get(FV).getCountClass(j);
                    probXi += probXi_temp;
                    double probXiCj = probXi_temp / (double)this.numInstances;
                    if (probXiCj == 0.0) continue;
                    info += probXiCj * (Math.log(probXiCj) / Math.log(10.0));
                }
                if ((probXi /= (double)this.numInstances) == 0.0) continue;
                info -= probXi * (Math.log(probXi) / Math.log(10.0));
            }
            if (!sMap.containsKey(info -= clsum)) {
                LinkedList<Integer> list = new LinkedList<Integer>();
                list.add(FN);
                sMap.put(info, list);
                continue;
            }
            ((LinkedList)sMap.get(info)).add(FN);
        }
        LinkedList<Integer> list2 = new LinkedList<Integer>();
        Iterator i$ = sMap.keySet().iterator();
        while (i$.hasNext()) {
            double sc = (Double)i$.next();
            list2.addAll((Collection)sMap.get(sc));
        }
        return list2;
    }

    private LinkedList<Integer> calculateCMI_Memory(int FN1, Vector<Integer> usedFeatures, int m) {
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        int fcnt = 0;
        int allfcnt = 0;
        double[] freq = (double[])this.trainResult.getClassFreqs().clone();
        LinkedList<Integer> usedFeatures_SortedCMIvalueListLL = new LinkedList<Integer>();
        NavigableMap<Double, LinkedList> sMap = new TreeMap().descendingMap();
        double sumXC = 0.0;
        for (Double FV1 : featureName_HT.get(FN1).keySet()) {
            for (int k = 0; k < this.numClasses; ++k) {
                double pXC = featureName_HT.get(FN1).get(FV1).getCountClass(k) / freq[k];
                if (pXC == 0.0) continue;
                sumXC += pXC * (Math.log(pXC) / Math.log(10.0));
            }
        }
        for (int FN2 : usedFeatures) {
            double CMIvalue = 0.0;
            double sumXYC = 0.0;
            double sumYC = 0.0;
            for (double FV2 : featureName_HT.get(FN2).keySet()) {
                for (int k = 0; k < this.numClasses; ++k) {
                    double pYC = featureName_HT.get(FN2).get(FV2).getCountClass(k) / freq[k];
                    if (pYC != 0.0) {
                        sumYC += pYC * (Math.log(pYC) / Math.log(10.0));
                    }
                    for (double FV1 : featureName_HT.get(FN1).keySet()) {
                        double pXYC = (double)this.compareConditionalInstanceIDLists(FN1, FV1, FN2, FV2, k) / freq[k];
                        if (pXYC == 0.0) continue;
                        sumXYC += pXYC * (Math.log(pXYC) / Math.log(10.0));
                    }
                }
            }
            CMIvalue = sumXYC - sumXC - sumYC;
            if (this.treshold < CMIvalue) {
                if (!sMap.containsKey(CMIvalue)) {
                    LinkedList<Integer> list = new LinkedList<Integer>();
                    list.add(FN2);
                    sMap.put(CMIvalue, list);
                } else {
                    ((LinkedList)sMap.get(CMIvalue)).add(FN2);
                }
                ++fcnt;
                ++allfcnt;
            }
            if (fcnt <= m + 10) continue;
            int delAmount = fcnt - m;
            while (delAmount > 0) {
                LinkedList list2 = (LinkedList)sMap.get(sMap.lastKey());
                if (list2.size() <= delAmount) {
                    delAmount -= list2.size();
                    fcnt -= list2.size();
                    sMap.remove(sMap.lastKey());
                    continue;
                }
                list2.removeFirst();
                sMap.put((Double)sMap.lastKey(), list2);
                --delAmount;
                --fcnt;
            }
        }
        Iterator i$ = sMap.keySet().iterator();
        while (i$.hasNext()) {
            double sc = (Double)i$.next();
            usedFeatures_SortedCMIvalueListLL.addAll((Collection)sMap.get(sc));
        }
        return usedFeatures_SortedCMIvalueListLL;
    }

    protected HashMap<Object, Double> calculateProbs(Instance inst) {
        System.out.println("Start classification process");
        HashMap<Object, Double> out = new HashMap<Object, Double>();
        this.coverAbsentFeatures_And_fill_helpMap(inst);
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        double[] freq = (double[])this.trainResult.getClassFreqs().clone();
        BayesNet BN = this.trainResult.getBayesNet(this.currentWorkingK).getBN();
        Set<Integer> List2 = BN.getNodes();
        for (int k = 0; k < this.numClasses; ++k) {
            Iterator<Integer> itrtlc = List2.iterator();
            double classScore = this.fnc.log2(freq[k] / (double)this.numInstances);
            while (itrtlc.hasNext()) {
                int feature_current = itrtlc.next();
                int numValues = featureName_HT.get(feature_current).size();
                Vector<Integer> parents = BN.getNodeParents(feature_current);
                TreeMap sMap = new TreeMap();
                Vector<Integer> list_instanceIDs = this.retrieveInstanceIDList(feature_current, this.getInstValue(feature_current, inst), k);
                double numerator = list_instanceIDs.size();
                double denominator = freq[k];
                if (parents.size() > 0) {
                    int parent;
                    Iterator<Integer> it = parents.iterator();
                    if (parents.size() > 3 && this.numFeatures > 50) {
                        while (it.hasNext()) {
                            parent = it.next();
                            int newsize = this.retrieveInstanceIDList(parent, this.getInstValue(parent, inst), k).size();
                            if (!sMap.containsKey(newsize)) {
                                LinkedList<Integer> list = new LinkedList<Integer>();
                                list.add(parent);
                                sMap.put(newsize, list);
                                continue;
                            }
                            ((LinkedList)sMap.get(newsize)).add(parent);
                        }
                        LinkedList list2 = new LinkedList();
                        Iterator i$ = sMap.keySet().iterator();
                        while (i$.hasNext()) {
                            int sc = (Integer)i$.next();
                            list2.addAll((Collection)sMap.get(sc));
                        }
                        it = list2.iterator();
                    }
                    parent = it.next();
                    Vector<Integer> parentList_instanceIDs = this.retrieveInstanceIDList(parent, this.getInstValue(parent, inst), k);
                    while (it.hasNext() && parentList_instanceIDs != null) {
                        parent = it.next();
                        parentList_instanceIDs = this.fnc.cutVectorsSort(parentList_instanceIDs, this.retrieveInstanceIDList(parent, this.getInstValue(parent, inst), k));
                    }
                    Vector<Integer> newlist = null;
                    denominator = parentList_instanceIDs.size();
                    if (parentList_instanceIDs != null) {
                        newlist = this.fnc.cutVectorsSort(list_instanceIDs, parentList_instanceIDs);
                    }
                    numerator = newlist.size();
                }
                classScore += this.fnc.log2((numerator + 1.0) / (denominator + (double)numValues));
            }
            out.put(this.classes[k], classScore);
        }
        out = this.calcFictionalChances(out);
        return out;
    }

    @Override
    public Map<Object, Double> classDistribution(Instance instance) {
        return this.calculateProbs(instance);
    }

    protected Vector<Integer> retrieveInstanceIDList(int FN, Double FV, int CV) {
        Hashtable<Integer, Hashtable<Double, ClassCounter>> featureName_HT = this.trainResult.getFeatureTable();
        Vector<Integer> v = null;
        if (featureName_HT.containsKey(FN) && featureName_HT.get(FN).containsKey(FV)) {
            v = featureName_HT.get(FN).get(FV).getClassInstanceIDList(CV);
        }
        return v;
    }

    protected int compareConditionalInstanceIDLists(int FN1, Double FV1, Integer FN2, Double FV2, int CV) {
        return this.fnc.cutVectorsSort(this.retrieveInstanceIDList(FN1, FV1, CV), this.retrieveInstanceIDList(FN2, FV2, CV)).size();
    }

    protected Vector<Integer> compareExistingConditionalInstanceIDLists(int FN1, Double FV1, Vector<Integer> v2, int CV) {
        return this.fnc.cutVectorsSort(this.retrieveInstanceIDList(FN1, FV1, CV), v2);
    }

    protected Vector<Integer> compareExistingConditionalInstanceIDLists(Vector<Integer> v1, Vector<Integer> v2) {
        return this.fnc.cutVectorsSort(v1, v2);
    }

    public void setBN(BayesNet BN, int workingK) {
        this.trainResult.getBayesNet(workingK).setBN(BN);
    }

    public void setcurrentWorkingK(int k) {
        this.currentWorkingK = k;
    }

    public double getTreshold() {
        return this.treshold;
    }

    public int[] getkparents() {
        return this.kparents;
    }

    public HashMap<Integer, Vector<Integer>>[] getBNs() {
        HashMap[] res = new HashMap[this.kparents.length];
        for (int r = 0; r < this.kparents.length; ++r) {
            res[r] = this.trainResult.getBayesNet(this.kparents[r]).getBN().getParentNodeMap();
        }
        return res;
    }
}

