/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import net.sf.javaml.core.AbstractInstance;
import net.sf.javaml.core.Instance;

public class SparseInstance
extends AbstractInstance
implements Instance {
    private HashMap<Integer, Double> data = new HashMap();
    private double defaultValue;
    private int noAttributes = -1;
    private static final long serialVersionUID = -7642462956857985858L;

    public void setNoAttributes(int noAttributes) {
        this.noAttributes = noAttributes;
    }

    public SparseInstance() {
        this(-1);
    }

    public SparseInstance(int noAttributes) {
        this(noAttributes, 0.0, null);
    }

    public SparseInstance(int noAttributes, double defaultValue) {
        this(noAttributes, defaultValue, null);
    }

    public SparseInstance(int noAttributes, Object classValue) {
        this(noAttributes, 0.0, classValue);
    }

    public SparseInstance(int noAttributes, double defaultValue, Object classValue) {
        super(classValue);
        this.defaultValue = defaultValue;
        this.noAttributes = noAttributes;
    }

    public SparseInstance(double[] datavector) {
        this(datavector, 0.0, null);
    }

    public SparseInstance(double[] datavector, double defaultValue) {
        this(datavector, defaultValue, null);
    }

    public SparseInstance(double[] datavector, Object classValue) {
        this(datavector, 0.0, classValue);
    }

    public SparseInstance(double[] datavector, double defaultValue, Object classValue) {
        super(classValue);
        this.defaultValue = defaultValue;
        this.initiate(datavector);
    }

    private void initiate(double[] datavector) {
        this.data.clear();
        this.noAttributes = datavector.length;
        for (int i = 0; i < datavector.length; ++i) {
            if (datavector[i] == this.defaultValue) continue;
            this.put(i, datavector[i]);
        }
    }

    @Override
    public double value(int pos) {
        return this.get(pos);
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.data.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.data.containsValue(value);
    }

    @Override
    public Set<Map.Entry<Integer, Double>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    public Double get(Object key) {
        if (this.data.containsKey(key)) {
            return this.data.get(key);
        }
        return this.defaultValue;
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public TreeSet<Integer> keySet() {
        TreeSet<Integer> set = new TreeSet<Integer>();
        set.addAll(this.data.keySet());
        return set;
    }

    @Override
    public Double put(Integer key, Double value) {
        return this.data.put(key, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Double> m) {
        this.data.putAll(m);
    }

    @Override
    public Double remove(Object key) {
        return this.data.remove(key);
    }

    @Override
    @Deprecated
    public int size() {
        return this.data.size();
    }

    @Override
    public Collection<Double> values() {
        return this.data.values();
    }

    @Override
    public int noAttributes() {
        if (this.noAttributes < 0) {
            if (this.data.keySet().size() == 0) {
                return 0;
            }
            return Collections.max(this.data.keySet()) + 1;
        }
        return this.noAttributes;
    }

    @Override
    public void removeAttribute(int remove) {
        this.data.remove(remove);
        Vector<Integer> indices = new Vector<Integer>();
        indices.addAll(this.data.keySet());
        Collections.sort(indices);
        for (int i = 0; i < indices.size(); ++i) {
            int index = (Integer)indices.get(i);
            if (index <= remove) continue;
            this.data.put(index - 1, this.data.get(index));
            this.data.remove(index);
        }
        --this.noAttributes;
    }

    public String toString() {
        return "{" + this.data.toString() + ";" + this.classValue() + "}";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        long temp = Double.doubleToLongBits(this.defaultValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseInstance other = (SparseInstance)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return Double.doubleToLongBits(this.defaultValue) == Double.doubleToLongBits(other.defaultValue);
    }

    @Override
    public Instance copy() {
        SparseInstance out = new SparseInstance();
        out.data = new HashMap();
        out.data.putAll(this.data);
        out.defaultValue = this.defaultValue;
        out.noAttributes = this.noAttributes;
        out.setClassValue(this.classValue());
        return out;
    }

    @Override
    public void removeAttributes(Set<Integer> indices) {
        Vector<Integer> indix = new Vector<Integer>();
        indix.addAll(indices);
        Collections.sort(indix);
        for (int i = indix.size() - 1; i >= 0; --i) {
            this.removeAttribute((Integer)indix.get(i));
        }
    }
}

