/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering.mcl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.sf.javaml.clustering.mcl.Vectors;

public class SparseVector
extends HashMap<Integer, Double> {
    private static final long serialVersionUID = 8101876335024188425L;
    private int length = 0;

    public SparseVector() {
    }

    public SparseVector(int i) {
        this();
        this.length = i;
    }

    public SparseVector(double[] x) {
        this(x.length);
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == 0.0) continue;
            this.put(i, x[i]);
        }
    }

    public SparseVector(SparseVector v) {
        super(v);
        this.length = v.length;
    }

    @Override
    public Double get(Object key) {
        Double b = (Double)super.get(key);
        if (b == null) {
            return 0.0;
        }
        return b;
    }

    @Override
    public Double put(Integer key, Double value) {
        this.length = Math.max(this.length, key + 1);
        if (value == 0.0) {
            return (Double)this.remove(key);
        }
        return super.put(key, value);
    }

    public void normalise() {
        double invsum = 1.0 / this.sum();
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            this.mult(i, invsum);
        }
    }

    public double normalise(double newsum) {
        double sum = this.sum();
        double invsum = newsum / sum;
        HashSet keys = new HashSet();
        keys.addAll(this.keySet());
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            this.mult(i, invsum);
        }
        return sum;
    }

    private double sum() {
        double sum = 0.0;
        Iterator i$ = this.values().iterator();
        while (i$.hasNext()) {
            double a = (Double)i$.next();
            sum += a;
        }
        return sum;
    }

    public double sum(double s) {
        double sum = 0.0;
        Iterator i$ = this.values().iterator();
        while (i$.hasNext()) {
            double a = (Double)i$.next();
            sum += Math.pow(a, s);
        }
        return sum;
    }

    public void add(SparseVector v) {
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            this.add(i, v.get(i));
        }
    }

    public void mult(int i, double a) {
        Double c = this.get(i);
        c = c * a;
        this.put(i, c);
    }

    public void factor(double a) {
        SparseVector s = this.copy();
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            s.mult(i, a);
        }
    }

    public double times(SparseVector v) {
        double sum = 0.0;
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            sum += this.get(i) * v.get(i);
        }
        return sum;
    }

    public void hadamardProduct(SparseVector v) {
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            this.put(i, v.get(i) * this.get(i));
        }
    }

    public void hadamardPower(double s) {
        HashSet keys = new HashSet();
        keys.addAll(this.keySet());
        Iterator i$ = keys.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            this.put(i, Math.pow(this.get(i), s));
        }
    }

    public void add(int i, double a) {
        this.length = Math.max(this.length, i + 1);
        double c = this.get(i);
        this.put(i, c += a);
    }

    public final int getLength() {
        return this.length;
    }

    public final void setLength(int length) {
        this.length = length;
    }

    public SparseVector copy() {
        return new SparseVector(this);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            sb.append(i).append("->").append(this.get(i)).append(", ");
        }
        return sb.toString();
    }

    public String toStringDense() {
        return Vectors.print(this.getDense());
    }

    public double[] getDense() {
        double[] a = new double[this.length];
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            a[i] = this.get(i);
        }
        return a;
    }

    public double max() {
        double max = 0.0;
        Iterator i$ = this.keySet().iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            max = Math.max(this.get(i), max);
        }
        return max;
    }

    public double expSum(int p) {
        double sum = 0.0;
        Iterator i$ = this.values().iterator();
        while (i$.hasNext()) {
            double a = (Double)i$.next();
            sum += Math.pow(a, p);
        }
        return sum;
    }

    public void prune(double threshold) {
        Iterator it = this.keySet().iterator();
        while (it.hasNext()) {
            int key = (Integer)it.next();
            if (!(Math.abs(this.get(key)) < threshold)) continue;
            it.remove();
        }
    }
}

