/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.clustering;

import java.io.Serializable;
import java.util.Vector;
import net.sf.javaml.clustering.Clusterer;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.Instance;
import net.sf.javaml.filter.DatasetFilter;
import net.sf.javaml.filter.normalize.NormalizeMean;

public class Cobweb
implements Clusterer {
    private static final double m_normal = 1.0 / (2.0 * Math.sqrt(Math.PI));
    private double m_acuity = 0.5;
    private double m_cutoff = 0.01 * m_normal;
    private CNode m_cobwebTree = null;
    private int m_numberOfClusters = -1;
    private boolean m_numberOfClustersDetermined = false;
    private int m_numberSplits;
    private int m_numberMerges;
    private DatasetFilter filter = new NormalizeMean();

    public Cobweb() {
        this(0.5, 0.01);
    }

    public Cobweb(double acuity, double cutoff) {
        this.m_acuity = acuity;
        this.m_cutoff = cutoff * m_normal;
    }

    private void determineNumberOfClusters() {
        if (!this.m_numberOfClustersDetermined && this.m_cobwebTree != null) {
            int[] numClusts = new int[]{0};
            this.m_cobwebTree.assignClusterNums(numClusts);
            this.m_numberOfClusters = numClusts[0];
            this.m_numberOfClustersDetermined = true;
        }
    }

    private void updateClusterer(Instance newInstance) {
        this.m_numberOfClustersDetermined = false;
        if (this.m_cobwebTree == null) {
            this.m_cobwebTree = new CNode(newInstance.noAttributes(), newInstance);
        } else {
            this.m_cobwebTree.addInstance(newInstance);
        }
    }

    @Override
    public Dataset[] cluster(Dataset data) {
        this.filter.filter(data);
        this.m_numberOfClusters = -1;
        this.m_cobwebTree = null;
        this.m_numberSplits = 0;
        this.m_numberMerges = 0;
        for (int i = 0; i < data.size(); ++i) {
            this.updateClusterer(data.instance(i));
        }
        this.determineNumberOfClusters();
        Vector<Dataset> clusters = new Vector<Dataset>();
        this.createClusters(this.m_cobwebTree, clusters);
        Dataset[] out = new Dataset[clusters.size()];
        clusters.toArray(out);
        return out;
    }

    private void createClusters(CNode tree, Vector<Dataset> clusters) {
        if (tree.m_children != null) {
            for (CNode y : tree.m_children) {
                this.createClusters(y, clusters);
            }
        } else {
            DefaultDataset tmp = new DefaultDataset();
            Dataset fromTree = tree.m_clusterInstances;
            for (int i = 0; i < fromTree.size(); ++i) {
                tmp.add(fromTree.instance(i));
            }
            clusters.add(tmp);
        }
    }

    private class CNode {
        private Stats[] m_attStats;
        private int m_numAttributes;
        private Dataset m_clusterInstances = null;
        private Vector<CNode> m_children = null;
        private double m_totalInstances = 0.0;

        private CNode(int numAttributes) {
            this.m_numAttributes = numAttributes;
        }

        private CNode(int numAttributes, Instance leafInstance) {
            this(numAttributes);
            if (this.m_clusterInstances == null) {
                this.m_clusterInstances = new DefaultDataset();
            }
            this.m_clusterInstances.add(leafInstance);
            this.updateStats(leafInstance, false);
        }

        private void addInstance(Instance newInstance) {
            if (this.m_clusterInstances == null) {
                this.m_clusterInstances = new DefaultDataset();
                this.m_clusterInstances.add(newInstance);
                this.updateStats(newInstance, false);
            } else if (this.m_children == null) {
                this.m_children = new Vector();
                CNode tempSubCluster = new CNode(this.m_numAttributes, this.m_clusterInstances.instance(0));
                for (int i = 1; i < this.m_clusterInstances.size(); ++i) {
                    tempSubCluster.m_clusterInstances.add(this.m_clusterInstances.instance(i));
                    tempSubCluster.updateStats(this.m_clusterInstances.instance(i), false);
                }
                this.m_children = new Vector();
                this.m_children.addElement(tempSubCluster);
                this.m_children.addElement(new CNode(this.m_numAttributes, newInstance));
                this.m_clusterInstances.add(newInstance);
                this.updateStats(newInstance, false);
                if (this.categoryUtility() < Cobweb.this.m_cutoff) {
                    this.m_children = null;
                }
            } else {
                CNode bestHost = this.findHost(newInstance, false);
                if (bestHost != null) {
                    bestHost.addInstance(newInstance);
                }
            }
        }

        private double[] cuScoresForChildren(Instance newInstance) {
            double[] categoryUtils = new double[this.m_children.size()];
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode temp = this.m_children.elementAt(i);
                temp.updateStats(newInstance, false);
                categoryUtils[i] = this.categoryUtility();
                temp.updateStats(newInstance, true);
            }
            return categoryUtils;
        }

        private double cuScoreForBestTwoMerged(CNode merged, CNode a, CNode b, Instance newInstance) {
            double mergedCU = -1.7976931348623157E308;
            merged.m_clusterInstances = new DefaultDataset();
            merged.addChildNode(a);
            merged.addChildNode(b);
            merged.updateStats(newInstance, false);
            this.m_children.removeElementAt(this.m_children.indexOf(a));
            this.m_children.removeElementAt(this.m_children.indexOf(b));
            this.m_children.addElement(merged);
            mergedCU = this.categoryUtility();
            merged.updateStats(newInstance, true);
            this.m_children.removeElementAt(this.m_children.indexOf(merged));
            this.m_children.addElement(a);
            this.m_children.addElement(b);
            return mergedCU;
        }

        private CNode findHost(Instance newInstance, boolean structureFrozen) {
            if (!structureFrozen) {
                this.updateStats(newInstance, false);
            }
            double[] categoryUtils = this.cuScoresForChildren(newInstance);
            CNode newLeaf = new CNode(this.m_numAttributes, newInstance);
            this.m_children.addElement(newLeaf);
            double bestHostCU = this.categoryUtility();
            CNode finalBestHost = newLeaf;
            this.m_children.removeElementAt(this.m_children.size() - 1);
            int best = 0;
            int secondBest = 0;
            for (int i = 0; i < categoryUtils.length; ++i) {
                if (!(categoryUtils[i] > categoryUtils[secondBest])) continue;
                if (categoryUtils[i] > categoryUtils[best]) {
                    secondBest = best;
                    best = i;
                    continue;
                }
                secondBest = i;
            }
            CNode a = this.m_children.elementAt(best);
            CNode b = this.m_children.elementAt(secondBest);
            if (categoryUtils[best] > bestHostCU) {
                bestHostCU = categoryUtils[best];
                finalBestHost = a;
            }
            if (structureFrozen) {
                if (finalBestHost == newLeaf) {
                    return null;
                }
                return finalBestHost;
            }
            double mergedCU = -1.7976931348623157E308;
            CNode merged = new CNode(this.m_numAttributes);
            if (a != b && (mergedCU = this.cuScoreForBestTwoMerged(merged, a, b, newInstance)) > bestHostCU) {
                bestHostCU = mergedCU;
                finalBestHost = merged;
            }
            double splitCU = -1.7976931348623157E308;
            double splitBestChildCU = -1.7976931348623157E308;
            double splitPlusNewLeafCU = -1.7976931348623157E308;
            double splitPlusMergeBestTwoCU = -1.7976931348623157E308;
            if (a.m_children != null) {
                int i;
                Vector<CNode> tempChildren = new Vector<CNode>();
                for (i = 0; i < this.m_children.size(); ++i) {
                    CNode existingChild = this.m_children.elementAt(i);
                    if (existingChild == a) continue;
                    tempChildren.addElement(existingChild);
                }
                for (i = 0; i < a.m_children.size(); ++i) {
                    CNode promotedChild = a.m_children.elementAt(i);
                    tempChildren.addElement(promotedChild);
                }
                tempChildren.addElement(newLeaf);
                Vector<CNode> saveStatusQuo = this.m_children;
                this.m_children = tempChildren;
                splitPlusNewLeafCU = this.categoryUtility();
                tempChildren.removeElementAt(tempChildren.size() - 1);
                categoryUtils = this.cuScoresForChildren(newInstance);
                best = 0;
                secondBest = 0;
                for (int i2 = 0; i2 < categoryUtils.length; ++i2) {
                    if (!(categoryUtils[i2] > categoryUtils[secondBest])) continue;
                    if (categoryUtils[i2] > categoryUtils[best]) {
                        secondBest = best;
                        best = i2;
                        continue;
                    }
                    secondBest = i2;
                }
                CNode sa = this.m_children.elementAt(best);
                CNode sb = this.m_children.elementAt(secondBest);
                splitBestChildCU = categoryUtils[best];
                CNode mergedSplitChildren = new CNode(this.m_numAttributes);
                if (sa != sb) {
                    splitPlusMergeBestTwoCU = this.cuScoreForBestTwoMerged(mergedSplitChildren, sa, sb, newInstance);
                }
                splitCU = splitBestChildCU > splitPlusNewLeafCU ? splitBestChildCU : splitPlusNewLeafCU;
                double d = splitCU = splitCU > splitPlusMergeBestTwoCU ? splitCU : splitPlusMergeBestTwoCU;
                if (splitCU > bestHostCU) {
                    bestHostCU = splitCU;
                    finalBestHost = this;
                } else {
                    this.m_children = saveStatusQuo;
                }
            }
            if (finalBestHost != this) {
                this.m_clusterInstances.add(newInstance);
            } else {
                Cobweb.this.m_numberSplits++;
            }
            if (finalBestHost == merged) {
                Cobweb.this.m_numberMerges++;
                this.m_children.removeElementAt(this.m_children.indexOf(a));
                this.m_children.removeElementAt(this.m_children.indexOf(b));
                this.m_children.addElement(merged);
            }
            if (finalBestHost == newLeaf) {
                finalBestHost = new CNode(this.m_numAttributes);
                this.m_children.addElement(finalBestHost);
            }
            if (bestHostCU < Cobweb.this.m_cutoff) {
                if (finalBestHost == this) {
                    this.m_clusterInstances.add(newInstance);
                }
                this.m_children = null;
                finalBestHost = null;
            }
            if (finalBestHost == this) {
                this.updateStats(newInstance, true);
            }
            return finalBestHost;
        }

        private void addChildNode(CNode child) {
            for (int i = 0; i < child.m_clusterInstances.size(); ++i) {
                Instance temp = child.m_clusterInstances.instance(i);
                this.m_clusterInstances.add(temp);
                this.updateStats(temp, false);
            }
            if (this.m_children == null) {
                this.m_children = new Vector();
            }
            this.m_children.addElement(child);
        }

        private double categoryUtility() {
            double totalCU = 0.0;
            for (int i = 0; i < this.m_children.size(); ++i) {
                CNode child = this.m_children.elementAt(i);
                totalCU += this.categoryUtilityChild(child);
            }
            return totalCU /= (double)this.m_children.size();
        }

        private double categoryUtilityChild(CNode child) {
            double sum = 0.0;
            for (int i = 0; i < this.m_numAttributes; ++i) {
                sum += m_normal / child.getStandardDev(i) - m_normal / this.getStandardDev(i);
            }
            return child.m_totalInstances / this.m_totalInstances * sum;
        }

        private double getStandardDev(int attIndex) {
            this.m_attStats[attIndex].calculateDerived();
            double stdDev = this.m_attStats[attIndex].stdDev;
            if (Double.isNaN(stdDev) || Double.isInfinite(stdDev)) {
                return Cobweb.this.m_acuity;
            }
            return Math.max(Cobweb.this.m_acuity, stdDev);
        }

        private void updateStats(Instance updateInstance, boolean delete) {
            int i;
            if (this.m_attStats == null) {
                this.m_attStats = new Stats[this.m_numAttributes];
                for (i = 0; i < this.m_numAttributes; ++i) {
                    this.m_attStats[i] = new Stats();
                }
            }
            for (i = 0; i < this.m_numAttributes; ++i) {
                double value = updateInstance.value(i);
                if (delete) {
                    this.m_attStats[i].subtract(value, 1.0);
                    continue;
                }
                this.m_attStats[i].add(value, 1.0);
            }
            this.m_totalInstances += delete ? -1.0 : 1.0;
        }

        private void assignClusterNums(int[] cl_num) {
            if (this.m_children != null && this.m_children.size() < 2) {
                throw new RuntimeException("assignClusterNums: tree not built correctly!");
            }
            cl_num[0] = cl_num[0] + 1;
            if (this.m_children != null) {
                for (int i = 0; i < this.m_children.size(); ++i) {
                    CNode child = this.m_children.elementAt(i);
                    child.assignClusterNums(cl_num);
                }
            }
        }
    }

    private class Stats
    implements Serializable {
        private static final long serialVersionUID = -8610544539090024102L;
        private double count = 0.0;
        private double sum = 0.0;
        private double sumSq = 0.0;
        private double stdDev = Double.NaN;
        private double min = Double.NaN;
        private double max = Double.NaN;

        private Stats() {
        }

        private void add(double value, double n) {
            this.sum += value * n;
            this.sumSq += value * value * n;
            this.count += n;
            if (Double.isNaN(this.min)) {
                this.min = this.max = value;
            } else if (value < this.min) {
                this.min = value;
            } else if (value > this.max) {
                this.max = value;
            }
        }

        private void subtract(double value, double n) {
            this.sum -= value * n;
            this.sumSq -= value * value * n;
            this.count -= n;
        }

        private void calculateDerived() {
            this.stdDev = Double.NaN;
            if (this.count > 0.0) {
                this.stdDev = Double.POSITIVE_INFINITY;
                if (this.count > 1.0) {
                    this.stdDev = this.sumSq - this.sum * this.sum / this.count;
                    this.stdDev /= this.count - 1.0;
                    if (this.stdDev < 0.0) {
                        this.stdDev = 0.0;
                    }
                    this.stdDev = Math.sqrt(this.stdDev);
                }
            }
        }
    }
}

