/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javaml.tools;

import java.util.Random;
import net.sf.javaml.core.Dataset;
import net.sf.javaml.core.DefaultDataset;
import net.sf.javaml.core.DenseInstance;
import net.sf.javaml.core.Instance;
import net.sf.javaml.core.SparseInstance;
import org.apache.commons.math.stat.StatUtils;

public final class DatasetTools {
    public static void merge(Dataset ... datasets) {
        Dataset out = null;
        for (Dataset data : datasets) {
            if (out == null) {
                out = data;
                continue;
            }
            out.addAll(data);
        }
    }

    @Deprecated
    public static Dataset bootstrap(Dataset data, int size, Random rg) {
        DefaultDataset out = new DefaultDataset();
        while (out.size() < size) {
            out.add(data.instance(rg.nextInt(data.size())).copy());
        }
        return out;
    }

    public static Instance maxAttributes(Dataset data) {
        SparseInstance max = new SparseInstance();
        for (Instance i : data) {
            for (Integer index : i.keySet()) {
                double val = i.value(index);
                if (!max.containsKey(index)) {
                    max.put(index, val);
                    continue;
                }
                if (!((Double)max.get(index) < val)) continue;
                max.put(index, val);
            }
        }
        return max;
    }

    public static Instance minAttributes(Dataset data) {
        SparseInstance min = new SparseInstance();
        for (Instance i : data) {
            for (Integer index : i.keySet()) {
                double val = i.value(index);
                if (!min.containsKey(index)) {
                    min.put(index, val);
                    continue;
                }
                if (!((Double)min.get(index) > val)) continue;
                min.put(index, val);
            }
        }
        return min;
    }

    public static Instance standardDeviation(Dataset data, Instance avg) {
        Instance sum = new DenseInstance(new double[avg.noAttributes()]);
        for (Instance i : data) {
            Instance diff = i.minus(avg);
            sum = sum.add(diff.multiply(diff));
        }
        sum = sum.divide(data.size());
        return sum.sqrt();
    }

    public static Instance average(Dataset data) {
        double[] tmpOut = new double[data.noAttributes()];
        for (int i = 0; i < data.noAttributes(); ++i) {
            double sum = 0.0;
            for (int j = 0; j < data.size(); ++j) {
                sum += ((Instance)data.get(j)).value(i);
            }
            tmpOut[i] = sum / (double)data.size();
        }
        return new DenseInstance(tmpOut);
    }

    public static Instance percentile(Dataset data, double perc) {
        double[] tmpOut = new double[data.noAttributes()];
        for (int i = 0; i < data.noAttributes(); ++i) {
            double[] vals = new double[data.size()];
            for (int j = 0; j < data.size(); ++j) {
                vals[j] = ((Instance)data.get(j)).value(i);
            }
            tmpOut[i] = StatUtils.percentile((double[])vals, (double)perc);
        }
        return new DenseInstance(tmpOut);
    }

    public static Instance createInstanceFromClass(Dataset data) {
        DenseInstance out = new DenseInstance(data.size());
        int index = 0;
        for (Instance inst : data) {
            out.put(index++, Double.valueOf(data.classIndex(inst.classValue())));
        }
        return out;
    }

    public static Instance createInstanceFromAttribute(Dataset data, int i) {
        DenseInstance out = new DenseInstance(data.size());
        int index = 0;
        for (Instance inst : data) {
            out.put(index++, inst.value(i));
        }
        return out;
    }

    private static double[][] getMinMax(Dataset data) {
        int noAttributes = ((Instance)data.get(0)).noAttributes();
        int noInstances = data.size();
        boolean MIN_INDEX = false;
        boolean MAX_INDEX = true;
        double[][] ret = new double[noAttributes][2];
        for (int a = 0; a < noAttributes; ++a) {
            ret[a][0] = Double.MAX_VALUE;
            ret[a][1] = Double.MIN_VALUE;
        }
        Instance instance = null;
        for (int i = 0; i < noInstances; ++i) {
            instance = (Instance)data.get(i);
            for (int a = 0; a < noAttributes; ++a) {
                double attrVal = instance.value(a);
                if (attrVal < ret[a][0]) {
                    ret[a][0] = attrVal;
                }
                if (!(attrVal > ret[a][1])) continue;
                ret[a][1] = attrVal;
            }
        }
        return ret;
    }

    public static double[] getRandomInstance(Dataset data, Random r) {
        boolean MIN_INDEX = false;
        boolean MAX_INDEX = true;
        double[][] minMax = DatasetTools.getMinMax(data);
        int noAttributes = minMax.length;
        double[] ret = new double[noAttributes];
        for (int a = 0; a < noAttributes; ++a) {
            ret[a] = minMax[a][0] + (minMax[a][1] - minMax[a][0]) * r.nextDouble();
        }
        return ret;
    }
}

